/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.attachment.IHasAttachments;
import io.github.tehstoneman.betterstorage.common.block.BlockBetterStorage;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockContainerBetterStorage
extends BlockBetterStorage
implements ITileEntityProvider {
    protected BlockContainerBetterStorage(String name, Material material) {
        super(name, material);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        TileEntity te = worldIn.func_175625_s(pos);
        return te != null ? te.func_145842_c(id, param) : false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityContainer) {
            ((TileEntityContainer)tileEntity).onBlockPlaced(placer, stack);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityContainer) {
            ((TileEntityContainer)tileEntity).onBlockDestroyed();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityContainer) {
            return ((TileEntityContainer)tileEntity).onBlockActivated(pos, state, playerIn, hand, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityContainer && !((TileEntityContainer)tileEntity).onBlockBreak(player)) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityContainer) {
            ((TileEntityContainer)tileEntity).onBlockDestroyed();
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityContainer) {
            ItemStack pick;
            TileEntityContainer container = (TileEntityContainer)tileEntity;
            if (container instanceof IHasAttachments && (pick = ((IHasAttachments)((Object)container)).getAttachments().pick(target)) != null) {
                return pick;
            }
            pick = super.getPickBlock(state, target, world, pos, player);
            return container.onPickBlock(pick, target);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityContainer)) {
            return 0;
        }
        TileEntityContainer tileContainer = (TileEntityContainer)tileEntity;
        return tileContainer.getComparatorSignalStrength();
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tileEntity = world.func_175625_s(neighbor);
        if (tileEntity instanceof TileEntityContainer) {
            ((TileEntityContainer)tileEntity).onNeighborUpdate(world.func_180495_p(neighbor).func_177230_c());
        }
    }
}

