/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.client.gui.BetterStorageGUIHandler;
import io.github.tehstoneman.betterstorage.common.block.BlockBetterStorage;
import io.github.tehstoneman.betterstorage.common.inventory.CrateStackHandler;
import io.github.tehstoneman.betterstorage.common.item.ItemBlockCrate;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityCrate;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(modid="Botania", iface="vazkii.botania.api.mana.ILaputaImmobile", striprefs=true)
public class BlockCrate
extends BlockBetterStorage
implements ITileEntityProvider {
    public static final PropertyBool CONNECTED_DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool CONNECTED_UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool CONNECTED_NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool CONNECTED_SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool CONNECTED_EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool CONNECTED_WEST = PropertyBool.func_177716_a((String)"west");

    public BlockCrate() {
        super("crate", Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CONNECTED_DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CONNECTED_WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected ItemBlock getItemBlock() {
        return new ItemBlockCrate(this);
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{CONNECTED_DOWN, CONNECTED_UP, CONNECTED_NORTH, CONNECTED_SOUTH, CONNECTED_EAST, CONNECTED_WEST};
        return new BlockStateContainer((Block)this, listedProperties);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = state.func_177226_a((IProperty)CONNECTED_DOWN, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.DOWN)));
        state = state.func_177226_a((IProperty)CONNECTED_UP, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.UP)));
        state = state.func_177226_a((IProperty)CONNECTED_NORTH, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.NORTH)));
        state = state.func_177226_a((IProperty)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.SOUTH)));
        state = state.func_177226_a((IProperty)CONNECTED_EAST, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.EAST)));
        state = state.func_177226_a((IProperty)CONNECTED_WEST, (Comparable)Boolean.valueOf(this.canConnect(worldIn, pos, EnumFacing.WEST)));
        return state;
    }

    public boolean canConnect(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        TileEntityCrate thisCrate = (TileEntityCrate)worldIn.func_175625_s(pos);
        TileEntity tileEntity = worldIn.func_175625_s(pos.func_177971_a(side.func_176730_m()));
        if (tileEntity instanceof TileEntityCrate) {
            TileEntityCrate connectedCrate = (TileEntityCrate)tileEntity;
            return thisCrate.getPileID().equals(connectedCrate.getPileID());
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityCrate();
    }

    public void onBlockPlacedExtended(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCrate) {
            TileEntityCrate crate = (TileEntityCrate)tileEntity;
            if (stack.func_82837_s()) {
                crate.setCustomTitle(stack.func_82833_r());
            }
            crate.attemptConnect(side.func_176734_d());
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCrate) {
            ((TileEntityCrate)tileEntity).onBlockPlaced(placer, stack);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntityCrate tileEntityCrate = (TileEntityCrate)worldIn.func_175625_s(pos);
        playerIn.openGui((Object)"betterstorage", BetterStorageGUIHandler.EnumGui.CRATE.getGuiID(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!world.field_72995_K && tileEntity instanceof TileEntityCrate) {
            TileEntityCrate tileCrate = (TileEntityCrate)tileEntity;
            CrateStackHandler handler = tileCrate.getCrateStackHandler();
            NonNullList<ItemStack> overflow = handler.removeCrate(tileCrate);
            tileCrate.notifyRegionUpdate(handler.getRegion(), tileCrate.getPileID());
            if (!overflow.isEmpty()) {
                for (ItemStack stack : overflow) {
                    if (stack.func_190926_b()) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
                }
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityCrate)) {
            return 0;
        }
        TileEntityCrate tileCrate = (TileEntityCrate)tileEntity;
        return tileCrate.getComparatorSignalStrength();
    }
}

