/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.api.BetterStorageAPI;
import io.github.tehstoneman.betterstorage.api.BetterStorageEnchantment;
import io.github.tehstoneman.betterstorage.api.EnumReinforced;
import io.github.tehstoneman.betterstorage.common.block.BlockContainerBetterStorage;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityConnectable;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLockable;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.Properties;

public abstract class BlockLockable
extends BlockContainerBetterStorage {
    public static final PropertyEnum MATERIAL = PropertyEnum.func_177709_a((String)"material", EnumReinforced.class);
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");

    protected BlockLockable(String name, Material material) {
        super(name, material);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        BlockStateContainer container = this.func_176194_O();
        if (container.func_177623_d().contains(MATERIAL)) {
            for (EnumReinforced material : EnumReinforced.values()) {
                ItemStack itemstack = new ItemStack((Block)this, 1, material.getMetadata());
                list.add((Object)itemstack);
            }
        } else {
            super.func_149666_a(tab, list);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D, MATERIAL, Properties.StaticProperty, CONNECTED});
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)((meta & 3) + 2));
        boolean hidden = (meta & 4) != 0;
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176745_a() - 2 & 3;
        return meta;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLockable) {
            TileEntityLockable lockable = (TileEntityLockable)tileEntity;
            if (lockable.getMaterial() != null) {
                state = state.func_177226_a((IProperty)MATERIAL, (Comparable)((Object)lockable.getMaterial()));
            }
            state = state.func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(lockable.isConnected()));
        }
        return state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityLockable) {
            TileEntityLockable lockable = (TileEntityLockable)tileentity;
            lockable.setMaterial(BetterStorageAPI.materials.get(stack));
        }
        if (tileentity instanceof TileEntityConnectable) {
            ((TileEntityConnectable)tileentity).onBlockPlaced(placer, stack);
        } else {
            super.func_180633_a(worldIn, pos, state, placer, stack);
        }
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntityLockable lockable;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLockable && !(lockable = (TileEntityLockable)tileEntity).getLock().func_190926_b()) {
            return -1.0f;
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntityLockable lockable;
        int persistance;
        float modifier = 1.0f;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLockable && (persistance = BetterStorageEnchantment.getLevel((lockable = (TileEntityLockable)tileEntity).getLock(), EnchantmentBetterStorage.persistance)) > 0) {
            modifier = (float)((double)modifier + Math.pow(2.0, persistance));
        }
        return super.func_149638_a(exploder) * modifier;
    }

    @Override
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = blockAccess.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLockable) {
            return ((TileEntityLockable)tileEntity).isPowered() ? 15 : 0;
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLockable) {
            ((TileEntityLockable)tileEntity).setPowered(false);
        }
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tileentity = world.func_175625_s(pos);
        EnumReinforced material = EnumReinforced.IRON;
        if (tileentity instanceof TileEntityLockable) {
            TileEntityLockable lockable = (TileEntityLockable)tileentity;
            material = lockable.getMaterial();
        }
        return new ItemStack(Item.func_150898_a((Block)this), 1, material.getMetadata());
    }
}

