/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.attachment.Attachments;
import io.github.tehstoneman.betterstorage.attachment.EnumAttachmentInteraction;
import io.github.tehstoneman.betterstorage.attachment.IHasAttachments;
import io.github.tehstoneman.betterstorage.common.block.BlockBetterStorage;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLockableDoor;
import io.github.tehstoneman.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLockableDoor
extends BlockBetterStorage {
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);

    public BlockLockableDoor() {
        super("lockable_door", Material.field_151573_f);
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        boolean flag = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b) == false;
        boolean flag1 = state.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.RIGHT;
        switch (enumfacing) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDoor.field_176520_a, BlockDoor.field_176519_b, BlockDoor.field_176521_M, BlockDoor.field_176523_O});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        return (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static int getCloseSound() {
        return 1011;
    }

    public static int getOpenSound() {
        return 1005;
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)((meta & 1) > 0 ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT)) : this.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f()).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            i |= 8;
            if (state.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.RIGHT) {
                i |= 1;
            }
        } else {
            i |= ((EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a)).func_176746_e().func_176736_b();
            if (((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
            if (iblockstate.func_177230_c() == this) {
                state = state.func_177226_a((IProperty)BlockDoor.field_176521_M, iblockstate.func_177229_b((IProperty)BlockDoor.field_176521_M));
            }
        } else {
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
            if (iblockstate1.func_177230_c() == this) {
                state = state.func_177226_a((IProperty)BlockDoor.field_176520_a, iblockstate1.func_177229_b((IProperty)BlockDoor.field_176520_a)).func_177226_a((IProperty)BlockDoor.field_176519_b, iblockstate1.func_177229_b((IProperty)BlockDoor.field_176519_b));
            }
        }
        return state;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntityLockableDoor lockable = WorldUtils.get((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), TileEntityLockableDoor.class);
        if (lockable != null && lockable.getLock() != null) {
            return -1.0f;
        }
        return super.func_176195_g(state, world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            pos = pos.func_177977_b();
        }
        if ((tileentity = world.func_175625_s(pos)) instanceof TileEntityLockableDoor) {
            return ((TileEntityLockableDoor)tileentity).onBlockActivated(world, pos, player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        Attachments attachments = WorldUtils.get((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), IHasAttachments.class).getAttachments();
        boolean abort = attachments.interact(WorldUtils.rayTrace(player, 1.0f), player, EnumAttachmentInteraction.attack);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Items.field_151139_aw);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.func_177977_b();
        BlockPos blockpos1 = pos.func_177984_a();
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER && worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER && worldIn.func_180495_p(blockpos1).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(blockpos1);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityLockableDoor lockable;
        ItemStack lock;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityLockableDoor && !(lock = (lockable = (TileEntityLockableDoor)tileentity).getLock()).func_190926_b()) {
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), lock));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityLockableDoor te = WorldUtils.get(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), TileEntityLockableDoor.class);
        return te == null ? 0 : (te.isPowered() ? 15 : 0);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? new TileEntityLockableDoor() : null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER;
    }
}

