/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.utils.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ReinforcedMaterial {
    private final String name;
    private final String modID;
    private final Object ingot;
    private final Object block;
    public static final String TAG_NAME = "Material";

    public ReinforcedMaterial(String name, Object ingot, Object block) {
        this("betterstorage", name, ingot, block);
    }

    public ReinforcedMaterial(String modID, String name, Object ingot, Object block) {
        this.modID = modID;
        this.name = name;
        this.ingot = ingot;
        this.block = block;
    }

    private ReinforcedMaterial(String name) {
        this("betterstorage", name, null, null);
    }

    public ShapedOreRecipe getReinforcedRecipe(Block middle, Block result) {
        return null;
    }

    public ResourceLocation getModelResource(String model, boolean large) {
        return new ResourceLocation(this.modID, "models/" + model + (large ? "_large/" : "/") + this.name);
    }

    public ResourceLocation getTextureResource(String model, boolean large) {
        return new ResourceLocation(this.modID, "textures/models/" + model + (large ? "_large/" : "/") + this.name + ".png");
    }

    public ItemStack setMaterial(ItemStack stack) {
        StackUtils.set(stack, this.name, TAG_NAME);
        return stack;
    }

    public String getUnlocalizedName() {
        return "material." + this.modID + "." + this.name;
    }
}

