/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.enchantment;

import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.common.item.locking.ItemLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;

public class EnchantmentLock
extends Enchantment {
    static final EnumEnchantmentType lockType = EnumHelper.addEnchantmentType((String)"lock", item -> item instanceof ItemLock);
    private final int maxLevel;
    private final int minBase;
    private final int minScaling;
    private final int maxBase;
    private final int maxScaling;
    private List<Enchantment> incompatible = new ArrayList<Enchantment>(0);

    protected EnchantmentLock(String name, Enchantment.Rarity rarityIn, int maxLevel, int minBase, int minScaling, int maxBase, int maxScaling) {
        super(rarityIn, lockType, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b("betterstorage.lock." + name);
        this.maxLevel = maxLevel;
        this.minBase = minBase;
        this.minScaling = minScaling;
        this.maxBase = maxBase;
        this.maxScaling = maxScaling;
    }

    public void setIncompatible(Enchantment ... incompatible) {
        this.incompatible = Arrays.asList(incompatible);
    }

    public int func_77325_b() {
        return this.maxLevel;
    }

    public int func_77321_a(int level) {
        return this.minBase + (level - 1) * this.minScaling;
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + this.maxBase + (level - 1) * this.maxScaling;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (this.field_77351_y == lockType && stack.func_77973_b() instanceof ILock) {
            ILock lock = (ILock)stack.func_77973_b();
            return lock.canApplyEnchantment(stack, this);
        }
        return false;
    }

    public boolean func_92089_a(ItemStack stack) {
        return this.canApplyAtEnchantingTable(stack);
    }

    public boolean func_77326_a(Enchantment other) {
        return super.func_77326_a(other) && !this.incompatible.contains(other);
    }

    public boolean isAllowedOnBooks() {
        return false;
    }
}

