/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import io.github.tehstoneman.betterstorage.common.inventory.Region;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityCrate;
import io.github.tehstoneman.betterstorage.common.world.CrateStackCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class CrateStackHandler
extends ItemStackHandler {
    private static final int maxCratePileSize = 125;
    private int numCrates;
    private Region region;
    private UUID pileID;
    private List<Integer> indexSlots;
    private boolean doShuffle = true;
    private TileEntityCrate crateToUpdate;

    public CrateStackHandler(int size) {
        super(size);
        this.indexSlots = this.getShuffledIndexes(size);
    }

    public int getNumCrates() {
        return this.numCrates;
    }

    public int getCapacity() {
        return CrateStackHandler.getCapacity(this.numCrates);
    }

    public static int getCapacity(int numCrates) {
        return numCrates * (18 + Math.min(numCrates / 6, 18));
    }

    public Region getRegion() {
        return this.region;
    }

    public int getOccupiedSlots() {
        int count = 0;
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public List<Integer> getShuffledIndexes(int count) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int occupied = this.getOccupiedSlots();
        for (int i = 0; i < Math.max(count, occupied); ++i) {
            list.add(i);
        }
        Collections.shuffle(list);
        return list.subList(0, count);
    }

    public int getIndexedSlot(int slot) {
        if (slot < 0) {
            slot = 0;
        }
        if (slot >= this.indexSlots.size()) {
            slot = this.indexSlots.size() - 1;
        }
        return this.indexSlots.get(slot);
    }

    public void consolidateStacks() {
        for (int i = 1; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b() || this.mergeItemStack((ItemStack)this.stacks.get(i), 0, i) != 0) continue;
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public int mergeItemStack(ItemStack stack, int startIndex, int endIndex) {
        if (stack.func_77985_e()) {
            for (int i = startIndex; stack.func_190916_E() > 0 && i < endIndex; ++i) {
                ItemStack itemstack = (ItemStack)this.stacks.get(i);
                if (itemstack.func_190926_b()) {
                    this.stacks.set(i, (Object)stack.func_77946_l());
                    stack.func_190920_e(0);
                    break;
                }
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemstack)) continue;
                int newSize = itemstack.func_190916_E() + stack.func_190916_E();
                if (newSize <= stack.func_77976_d()) {
                    stack.func_190920_e(0);
                    itemstack.func_190920_e(newSize);
                    continue;
                }
                if (itemstack.func_190916_E() >= stack.func_77976_d()) continue;
                int count = stack.func_77976_d() - itemstack.func_190916_E();
                stack.func_190920_e(stack.func_190916_E() - count);
                itemstack.func_190920_e(stack.func_77976_d());
            }
        }
        return stack.func_190916_E();
    }

    public boolean canAdd(TileEntityCrate crate) {
        return this.numCrates < 125 && (this.region.contains(crate.func_174877_v()) || this.canExpand(crate));
    }

    private boolean canExpand(TileEntityCrate crate) {
        int volume = this.region.volume();
        if (this.numCrates < volume) {
            return false;
        }
        int width = this.region.width();
        int height = this.region.height();
        int depth = this.region.depth();
        if (crate.func_174877_v().func_177958_n() < this.region.posMin.func_177958_n() || crate.func_174877_v().func_177958_n() > this.region.posMax.func_177958_n()) {
            int maxDiff;
            if (width >= 125) {
                return false;
            }
            int n = maxDiff = height == 1 ? 1 : 3;
            if (width >= maxDiff + Math.min(height, depth)) {
                return false;
            }
        } else if (crate.func_174877_v().func_177952_p() < this.region.posMin.func_177952_p() || crate.func_174877_v().func_177952_p() > this.region.posMax.func_177952_p()) {
            int maxDiff;
            if (depth >= 125) {
                return false;
            }
            int n = maxDiff = width == 1 ? 1 : 3;
            if (depth >= maxDiff + Math.min(height, depth)) {
                return false;
            }
        } else if (crate.func_174877_v().func_177956_o() < this.region.posMin.func_177956_o() || crate.func_174877_v().func_177956_o() > this.region.posMax.func_177956_o()) {
            int maxDiff;
            if (height >= 125) {
                return false;
            }
            int n = maxDiff = width == 1 || depth == 1 ? 1 : 4;
            if (height >= maxDiff + Math.min(width, depth)) {
                return false;
            }
        }
        return true;
    }

    public void addCrate(TileEntityCrate crate) {
        if (this.numCrates == 0 || this.region == null) {
            this.region = new Region(crate);
        } else {
            this.region.expandToContain(crate);
        }
        ++this.numCrates;
        this.stacks = this.copyStack((NonNullList<ItemStack>)this.stacks, this.getCapacity());
        crate.setPileID(this.getPileID());
    }

    public NonNullList<ItemStack> removeCrate(TileEntityCrate crate) {
        if (this.numCrates > 1) {
            NonNullList<ItemStack> overflow = this.copyStack((NonNullList<ItemStack>)this.stacks, CrateStackHandler.getCapacity(this.numCrates - 1), this.stacks.size());
            this.setNumCrates(this.numCrates - 1);
            CrateStackCollection.getCollection(crate.func_145831_w()).func_76185_a();
            return overflow;
        }
        CrateStackCollection.getCollection(crate.func_145831_w()).removeCratePile(this.pileID);
        return this.stacks;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setNumCrates(int numCrates) {
        this.numCrates = numCrates;
        this.stacks = this.copyStack((NonNullList<ItemStack>)this.stacks, this.getCapacity());
    }

    public UUID getPileID() {
        return this.pileID;
    }

    public void setPileID(UUID pileID) {
        this.pileID = pileID;
    }

    public ItemStack[] getRandomStacks(int count) {
        List items = this.stacks.subList(0, this.stacks.size());
        Collections.shuffle(items);
        return (ItemStack[])Arrays.copyOf(items.toArray(), count);
    }

    public void removeItems(ItemStack itemStack) {
        int i;
        for (i = 0; i < this.stacks.size() && !ItemStack.func_77989_b((ItemStack)((ItemStack)this.stacks.get(i)), (ItemStack)itemStack); ++i) {
        }
        if (i < this.stacks.size() && !((ItemStack)this.stacks.get(i)).func_190926_b()) {
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public void addItems(ItemStack stack) {
        int i;
        for (i = 0; i < this.stacks.size() && !((ItemStack)this.stacks.get(i)).func_190926_b(); ++i) {
        }
        if (i < this.stacks.size() && !((ItemStack)this.stacks.get(i)).func_190926_b()) {
            this.stacks.set(i, (Object)stack.func_77946_l());
        }
    }

    public void trimRegion(World world) {
        Region region = null;
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.region.posMin, (BlockPos)this.region.posMax)) {
            TileEntityCrate crate;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (!(tileEntity instanceof TileEntityCrate) || !(crate = (TileEntityCrate)tileEntity).getPileID().equals(this.pileID)) continue;
            if (region == null) {
                region = new Region(pos, pos);
                continue;
            }
            region.expandToContain(pos);
        }
        if (region != null) {
            this.region = region;
        }
    }

    public void setSize(int size) {
        this.stacks = this.copyStack((NonNullList<ItemStack>)this.stacks, size);
        this.indexSlots = this.getShuffledIndexes(size);
    }

    public NonNullList<ItemStack> copyStack(NonNullList<ItemStack> stackIn, int size) {
        return this.copyStack(stackIn, 0, size);
    }

    public NonNullList<ItemStack> copyStack(NonNullList<ItemStack> stackIn, int from, int to) {
        int size = to - from;
        NonNullList stackOut = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < Math.min(size, stackIn.size()); ++i) {
            stackOut.set(i, stackIn.get(i + from));
        }
        return stackOut;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(this.getIndexedSlot(slot), stack);
    }

    public void setStackInSlotFixed(int slot, ItemStack stack) {
        this.doShuffle = false;
        super.setStackInSlot(slot, stack);
        this.doShuffle = true;
    }

    public ItemStack getStackInSlot(int slot) {
        return super.getStackInSlot(this.getIndexedSlot(slot));
    }

    public ItemStack getStackInSlotFixed(int slot) {
        return super.getStackInSlot(slot);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(this.getIndexedSlot(slot), amount, simulate);
    }

    public ItemStack extractItemFixed(int slot, int amount, boolean simulate) {
        this.doShuffle = false;
        ItemStack result = super.extractItem(slot, amount, simulate);
        this.doShuffle = true;
        return result;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return super.insertItem(this.getIndexedSlot(slot), stack, simulate);
    }

    public ItemStack insertItemFixed(int slot, ItemStack stack, boolean simulate) {
        this.doShuffle = false;
        ItemStack result = super.insertItem(slot, stack, simulate);
        this.doShuffle = true;
        return result;
    }

    public void sendUpdatesTo(TileEntityCrate tileEntityCrate) {
        this.crateToUpdate = tileEntityCrate;
    }

    protected void onContentsChanged(int slot) {
        if (this.doShuffle) {
            this.consolidateStacks();
            this.indexSlots = this.getShuffledIndexes(this.stacks.size());
        }
        if (this.crateToUpdate != null) {
            this.crateToUpdate.func_70296_d();
        }
    }

    protected void onLoad() {
        this.indexSlots = this.getShuffledIndexes(this.stacks.size());
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("NumCrates", this.numCrates);
        if (this.pileID != null) {
            compound.func_186854_a("PileID", this.pileID);
        }
        if (this.region != null) {
            compound.func_74782_a("Region", (NBTBase)this.region.toCompound());
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.numCrates = compound.func_74762_e("NumCrates");
        if (compound.func_186855_b("PileID")) {
            this.pileID = compound.func_186857_a("PileID");
        }
        if (compound.func_74764_b("Region")) {
            this.region = Region.fromCompound(compound.func_74775_l("Region"));
        }
        this.onLoad();
    }
}

