/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import io.github.tehstoneman.betterstorage.common.inventory.KeyringStackHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;

public class KeyringCapabilityProvider
implements ICapabilitySerializable<NBTTagCompound> {
    private final ItemStack invItem;
    public KeyringStackHandler inventory;

    public KeyringCapabilityProvider(ItemStack stack) {
        this.invItem = stack;
        int size = this.getSizeContents();
        this.inventory = size > 0 ? new KeyringStackHandler(size){

            protected void onContentsChanged(int slot) {
                KeyringCapabilityProvider.this.markDirty();
            }
        } : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)((Object)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : null));
    }

    protected int getSizeContents() {
        return 9;
    }

    public void markDirty() {
        int count = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ++count;
        }
        this.invItem.func_77964_b((int)Math.ceil((double)count / 3.0));
    }

    public NBTTagCompound serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inventory.deserializeNBT(nbt);
    }
}

