/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class Region {
    public BlockPos posMin;
    public BlockPos posMax;

    public Region(BlockPos posMin, BlockPos posMax) {
        this.set(posMin, posMax);
    }

    public Region(TileEntity entity) {
        this(entity.func_174877_v(), entity.func_174877_v());
    }

    public int width() {
        return this.posMax.func_177958_n() - this.posMin.func_177958_n() + 1;
    }

    public int depth() {
        return this.posMax.func_177952_p() - this.posMin.func_177952_p() + 1;
    }

    public int height() {
        return this.posMax.func_177956_o() - this.posMin.func_177956_o() + 1;
    }

    public int volume() {
        return this.width() * this.depth() * this.height();
    }

    public void set(BlockPos posMin, BlockPos posMax) {
        this.posMin = new BlockPos(Math.min(posMin.func_177958_n(), posMax.func_177958_n()), Math.min(posMin.func_177956_o(), posMax.func_177956_o()), Math.min(posMin.func_177952_p(), posMax.func_177952_p()));
        this.posMax = new BlockPos(Math.max(posMin.func_177958_n(), posMax.func_177958_n()), Math.max(posMin.func_177956_o(), posMax.func_177956_o()), Math.max(posMin.func_177952_p(), posMax.func_177952_p()));
    }

    public void expand(BlockPos posMin, BlockPos posMax) {
        this.posMin.func_177973_b((Vec3i)new BlockPos(Math.min(posMin.func_177958_n(), posMax.func_177958_n()), Math.min(posMin.func_177956_o(), posMax.func_177956_o()), Math.min(posMin.func_177952_p(), posMax.func_177952_p())));
        this.posMax.func_177971_a((Vec3i)new BlockPos(Math.max(posMin.func_177958_n(), posMax.func_177958_n()), Math.max(posMin.func_177956_o(), posMax.func_177956_o()), Math.max(posMin.func_177952_p(), posMax.func_177952_p())));
    }

    public void expand(int size) {
        this.expand(new BlockPos(size, size, size), new BlockPos(size, size, size));
    }

    public void expandToContain(BlockPos pos) {
        this.posMin = new BlockPos(Math.min(this.posMin.func_177958_n(), pos.func_177958_n()), Math.min(this.posMin.func_177956_o(), pos.func_177956_o()), Math.min(this.posMin.func_177952_p(), pos.func_177952_p()));
        this.posMax = new BlockPos(Math.max(this.posMax.func_177958_n(), pos.func_177958_n()), Math.max(this.posMax.func_177956_o(), pos.func_177956_o()), Math.max(this.posMax.func_177952_p(), pos.func_177952_p()));
    }

    public void expandToContain(TileEntity entity) {
        this.expandToContain(entity.func_174877_v());
    }

    public void contract(BlockPos posMin, BlockPos posMax) {
        this.posMin.func_177971_a((Vec3i)new BlockPos(Math.min(posMin.func_177958_n(), posMax.func_177958_n()), Math.min(posMin.func_177956_o(), posMax.func_177956_o()), Math.min(posMin.func_177952_p(), posMax.func_177952_p())));
        this.posMax.func_177973_b((Vec3i)new BlockPos(Math.max(posMin.func_177958_n(), posMax.func_177958_n()), Math.max(posMin.func_177956_o(), posMax.func_177956_o()), Math.max(posMin.func_177952_p(), posMax.func_177952_p())));
    }

    public boolean contains(BlockPos pos) {
        return pos.func_177958_n() >= this.posMin.func_177958_n() && pos.func_177956_o() >= this.posMin.func_177956_o() && pos.func_177952_p() >= this.posMin.func_177952_p() && pos.func_177958_n() <= this.posMax.func_177958_n() && pos.func_177956_o() <= this.posMax.func_177956_o() && pos.func_177952_p() <= this.posMax.func_177952_p();
    }

    public boolean contains(TileEntity entity) {
        return this.contains(entity.func_174877_v());
    }

    public NBTTagCompound toCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74772_a("posMin", this.posMin.func_177986_g());
        compound.func_74772_a("posMax", this.posMax.func_177986_g());
        return compound;
    }

    public static Region fromCompound(NBTTagCompound compound) {
        BlockPos posMin = BlockPos.func_177969_a((long)compound.func_74763_f("posMin"));
        BlockPos posMax = BlockPos.func_177969_a((long)compound.func_74763_f("posMax"));
        return new Region(posMin, posMax);
    }

    public Region clone() {
        return new Region(this.posMin, this.posMax);
    }

    public String toString() {
        return "[ " + this.posMin.func_177958_n() + "," + this.posMin.func_177956_o() + "," + this.posMin.func_177952_p() + " : " + this.posMax.func_177958_n() + "," + this.posMax.func_177956_o() + "," + this.posMax.func_177952_p() + " ]";
    }
}

