/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.common.item.ItemBetterStorage;
import io.github.tehstoneman.betterstorage.utils.LanguageUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBucketSlime
extends ItemBetterStorage {
    private static Map<ResourceLocation, Handler> handlers = new HashMap<ResourceLocation, Handler>();

    public ItemBucketSlime() {
        super("bucket");
        this.func_77642_a(Items.field_151133_ar);
        this.func_77627_a(true);
        this.func_77625_d(0);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(BetterStorage.creativeTab);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (EnumSlime slime : EnumSlime.values()) {
                subItems.add((Object)new ItemStack((Item)this, 1, slime.getMetadata()));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + EnumSlime.byMetadata(0).getUnlocalizedName();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77948_v() || stack.func_77942_o() && stack.func_77978_p().func_74764_b("effects");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag toolTipFlag) {
        NBTTagList effectList;
        NBTTagCompound compound;
        EnumSlime slime = EnumSlime.byMetadata(stack.func_77960_j());
        ResourceLocation resourceLocation = slime.getResourceLocation();
        Handler handler = ItemBucketSlime.getHandler(resourceLocation);
        String name = null;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("name")) {
            name = compound.func_74779_i("name");
        }
        if (name != null || toolTipFlag.func_194127_a()) {
            String localName = name != null ? "\"" + name + "\"" + (toolTipFlag.func_194127_a() ? " (" + BetterStorage.proxy.localize(handler.entityName, new Object[0]) + ")" : "") : BetterStorage.proxy.localize(handler.entityName, new Object[0]);
            tooltip.add(BetterStorage.proxy.localize("tooltip.betterstorage.bucket.slime.contains", localName));
        }
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("effects") && (effectList = compound.func_150295_c("effects", 10)) != null && handler != null) {
            int max = toolTipFlag.func_194127_a() || GuiScreen.func_146272_n() ? 6 : 3;
            for (int i = 0; i < Math.min(effectList.func_74745_c(), max); ++i) {
                PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)effectList.func_150305_b(i));
                Potion potion = effect.func_188419_a();
                int duration = (int)((float)effect.func_76459_b() * handler.durationMultiplier());
                StringBuilder str = new StringBuilder().append(potion.func_76398_f() ? TextFormatting.RED : TextFormatting.GRAY).append(BetterStorage.proxy.localize(effect.func_76453_d(), new Object[0]));
                if (effect.func_76458_c() > 0) {
                    str.append(" ").append(BetterStorage.proxy.localize("potion.potency." + effect.func_76458_c(), new Object[0]));
                }
                str.append(" (").append(StringUtils.func_76337_a((int)duration)).append(")");
                tooltip.add(str.toString());
            }
            int more = effectList.func_74745_c() - max;
            if (more > 0) {
                tooltip.add(TextFormatting.DARK_GRAY.toString() + TextFormatting.ITALIC + LanguageUtils.translateTooltip("bucketSlime.more." + (more == 1 ? "1" : "x"), "%X%", Integer.toString(more)));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            return EnumActionResult.FAIL;
        }
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ResourceLocation resourceLocation = ItemBucketSlime.getSlimeId(stack);
        BlockPos blockpos = pos.func_177972_a(facing);
        Handler handler = ItemBucketSlime.getHandler(resourceLocation);
        double d0 = this.getYOffset(worldIn, blockpos);
        Entity entity = ItemMonsterPlacer.func_77840_a((World)worldIn, (ResourceLocation)handler.resourceLocation, (double)((double)blockpos.func_177958_n() + 0.5), (double)((double)blockpos.func_177956_o() + d0), (double)((double)blockpos.func_177952_p() + 0.5));
        if (entity != null && handler != null && entity instanceof EntityLiving) {
            EntityLiving slime = (EntityLiving)entity;
            handler.setSize(slime, 1);
            if (stack.func_77942_o()) {
                NBTTagList effectList;
                NBTTagCompound compound = stack.func_77978_p();
                if (compound.func_74764_b("name")) {
                    entity.func_96094_a(compound.func_74779_i("name"));
                }
                if ((effectList = compound.func_150295_c("effects", 10)) != null) {
                    for (int i = 0; i < effectList.func_74745_c(); ++i) {
                        slime.func_70690_d(PotionEffect.func_82722_b((NBTTagCompound)effectList.func_150305_b(i)));
                    }
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 48;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (handIn == EnumHand.MAIN_HAND) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            Handler handler = ItemBucketSlime.getHandler(stack);
            if (handler != null) {
                NBTTagCompound compound;
                player.func_71024_bL().func_75122_a(handler.foodAmount(), handler.saturationAmount());
                if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("effects")) {
                    NBTTagList effectList = compound.func_150295_c("effects", 10);
                    for (int i = 0; i < effectList.func_74745_c(); ++i) {
                        PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)effectList.func_150305_b(i));
                        int duration = (int)((float)effect.func_76459_b() * handler.durationMultiplier());
                        effect = new PotionEffect(effect.func_188419_a(), duration, effect.func_76458_c());
                        player.func_70690_d(effect);
                    }
                }
                handler.onEaten(player, false);
            }
        }
        return new ItemStack(Items.field_151133_ar);
    }

    public static void pickUpSlime(EntityPlayer player, EntityLiving slime) {
        Collection effects;
        Handler handler = ItemBucketSlime.getHandler(slime);
        if (slime.field_70128_L || handler == null || handler.getSize(slime) != 1) {
            return;
        }
        ItemStack stack = new ItemStack((Item)BetterStorageItems.SLIME_BUCKET, 1, EnumSlime.byName(handler.name).getMetadata());
        String entityId = EntityList.func_75621_b((Entity)slime);
        if (slime.func_145818_k_()) {
            NBTTagCompound compound = new NBTTagCompound();
            if (stack.func_77942_o()) {
                compound = stack.func_77978_p();
            }
            compound.func_74778_a("name", slime.func_95999_t());
            stack.func_77982_d(compound);
        }
        if (!(effects = slime.func_70651_bq()).isEmpty()) {
            NBTTagCompound compound = new NBTTagCompound();
            if (stack.func_77942_o()) {
                compound = stack.func_77978_p();
            }
            NBTTagList effectList = new NBTTagList();
            for (PotionEffect effect : effects) {
                effectList.func_74742_a((NBTBase)effect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("effects", (NBTBase)effectList);
            stack.func_77982_d(compound);
        }
        if (player.func_184614_ca().func_190916_E() <= 1) {
            player.func_184611_a(EnumHand.MAIN_HAND, stack);
        } else {
            player.func_184614_ca().func_190918_g(1);
            if (!player.field_71071_by.func_70441_a(stack)) {
                player.func_146097_a(stack, true, false);
            } else {
                ((EntityPlayerMP)player).field_71069_bz.func_75142_b();
            }
        }
        slime.func_184185_a(SoundEvents.field_187882_fq, 1.2f, 0.8f);
        slime.field_70128_L = true;
    }

    public static ResourceLocation getSlimeId(ItemStack stack) {
        return EnumSlime.byMetadata(stack.func_77960_j()).getResourceLocation();
    }

    public static void registerHandler(Handler handler) {
        handlers.put(handler.resourceLocation, handler);
    }

    public static Handler getHandler(ResourceLocation resourceLocation) {
        return handlers.get(resourceLocation);
    }

    public static Handler getHandler(EntityLiving slime) {
        return ItemBucketSlime.getHandler(EntityList.func_191301_a((Entity)slime));
    }

    public static Handler getHandler(ItemStack stack) {
        return ItemBucketSlime.getHandler(ItemBucketSlime.getSlimeId(stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        for (EnumSlime slime : EnumSlime.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)slime.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_" + slime.getUnlocalizedName(), "inventory"));
        }
    }

    protected double getYOffset(World p_190909_1_, BlockPos p_190909_2_) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(p_190909_2_).func_72321_a(0.0, -1.0, 0.0);
        List list = p_190909_1_.func_184144_a((Entity)null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)p_190909_2_.func_177956_o();
    }

    static {
        ItemBucketSlime.registerHandler(new Handler(EnumSlime.GREEN_SLIME.name, new ResourceLocation(EnumSlime.GREEN_SLIME.getUnlocalizedName())){

            @Override
            public int foodAmount() {
                return 3;
            }

            @Override
            public float saturationAmount() {
                return 0.2f;
            }
        });
        ItemBucketSlime.registerHandler(new Handler(EnumSlime.MAGMA_CUBE.name, new ResourceLocation(EnumSlime.MAGMA_CUBE.getUnlocalizedName())){

            @Override
            public float durationMultiplier() {
                return 0.4f;
            }

            @Override
            public void onEaten(EntityPlayer player, boolean potionEffects) {
                player.func_70015_d(2);
                player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"jump_boost"), (potionEffects ? 10 : 20) * 20, potionEffects ? 2 : 3));
                player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"strength"), (potionEffects ? 24 : 32) * 20, 0));
            }
        });
    }

    public static enum EnumSlime implements IStringSerializable
    {
        GREEN_SLIME(0, "Slime", new ResourceLocation("slime")),
        MAGMA_CUBE(1, "LavaSlime", new ResourceLocation("magma_cube"));

        private final int meta;
        private final String name;
        private final ResourceLocation resourceLocation;
        private static EnumSlime[] META_LOOKUP;
        private static Map<String, EnumSlime> NAME_LOOKUP;

        private EnumSlime(int meta, String name, ResourceLocation resourceLocation) {
            this.meta = meta;
            this.name = name;
            this.resourceLocation = resourceLocation;
        }

        public static EnumSlime byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static EnumSlime byName(String name) {
            return NAME_LOOKUP.get(name);
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        public String getUnlocalizedName() {
            return this.resourceLocation.func_110623_a();
        }

        public int getMetadata() {
            return this.meta;
        }

        static {
            META_LOOKUP = new EnumSlime[EnumSlime.values().length];
            NAME_LOOKUP = new HashMap<String, EnumSlime>();
            EnumSlime[] enumSlimeArray = EnumSlime.values();
            int n = enumSlimeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumSlime slime;
                EnumSlime.META_LOOKUP[slime.getMetadata()] = slime = enumSlimeArray[i];
                NAME_LOOKUP.put(slime.name, slime);
            }
        }
    }

    public static class Handler {
        public final String name;
        public final String entityName;
        public final ResourceLocation resourceLocation;

        public Handler(String name, String entityName) {
            this.name = name;
            this.entityName = entityName;
            this.resourceLocation = null;
        }

        public Handler(String name, ResourceLocation resource) {
            this.name = name;
            this.entityName = EntityList.func_191302_a((ResourceLocation)resource);
            this.resourceLocation = resource;
        }

        public int getSize(EntityLiving slime) {
            if (slime instanceof EntitySlime) {
                return ((EntitySlime)slime).func_70809_q();
            }
            return 0;
        }

        public void setSize(EntityLiving slime, int size) {
            NBTTagCompound compound = new NBTTagCompound();
            slime.func_189511_e(compound);
            compound.func_74768_a("Size", size - 1);
            slime.func_70020_e(compound);
        }

        public int foodAmount() {
            return 4;
        }

        public float saturationAmount() {
            return 0.3f;
        }

        public float durationMultiplier() {
            return 0.25f;
        }

        public void onEaten(EntityPlayer player, boolean potionEffects) {
            player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"jump_boost"), (potionEffects ? 6 : 16) * 20, 1));
        }
    }
}

