/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.cardboard;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.api.ICardboardItem;
import io.github.tehstoneman.betterstorage.api.IContainerItem;
import io.github.tehstoneman.betterstorage.utils.StackUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class ItemBlockCardboardBox
extends ItemBlock
implements IContainerItem,
ICardboardItem {
    public ItemBlockCardboardBox(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int maxUses = ItemBlockCardboardBox.getUses();
        if (maxUses > 1) {
            int uses = maxUses;
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("uses")) {
                uses = Math.min(maxUses, stack.func_77978_p().func_74762_e("uses"));
            }
            return uses < maxUses;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int maxUses = ItemBlockCardboardBox.getUses();
        return 1.0f - (float)StackUtils.get(stack, maxUses, "uses").intValue() / (float)maxUses;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag toolTipFlag) {
        int i;
        boolean hasItems;
        int maxUses = ItemBlockCardboardBox.getUses();
        boolean bl = hasItems = stack.func_77942_o() && stack.func_77978_p().func_74764_b("Inventory");
        if (!hasItems && BetterStorage.config.enableHelpTooltips) {
            tooltip.add(BetterStorage.proxy.localize("tooltip.betterstorage.cardboardBox.useHint" + (maxUses > 0 ? ".reusable" : Integer.valueOf(0)), new Object[0]));
        }
        if (maxUses > 1) {
            int uses = maxUses;
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("uses")) {
                uses = Math.min(maxUses, stack.func_77978_p().func_74762_e("uses"));
            }
            tooltip.add(TextFormatting.DARK_GRAY.toString() + TextFormatting.ITALIC + BetterStorage.proxy.localize("tooltip.betterstorage.cardboardBox.uses", uses));
        }
        if (!hasItems) {
            return;
        }
        if (!BetterStorage.config.cardboardBoxShowContents) {
            tooltip.add(BetterStorage.proxy.localize("tooltip.betterstorage.cardboardBox.containsItems", new Object[0]));
            return;
        }
        ItemStackHandler contents = new ItemStackHandler(9);
        contents.deserializeNBT(stack.func_77978_p().func_74775_l("Inventory"));
        int limit = toolTipFlag.func_194127_a() || GuiScreen.func_146272_n() ? 6 : 3;
        ArrayList<DisplayNameStack> items = new ArrayList<DisplayNameStack>();
        for (i = 0; i < contents.getSlots(); ++i) {
            ItemStack contentStack = contents.getStackInSlot(i);
            if (contentStack.func_190926_b()) continue;
            boolean added = false;
            if (items.size() > 0) {
                for (int j = 0; j < items.size(); ++j) {
                    if (!((DisplayNameStack)items.get(j)).matchAndAdd(contentStack)) continue;
                    added = true;
                    break;
                }
            }
            if (added) continue;
            items.add(new DisplayNameStack(contentStack));
        }
        Collections.sort(items);
        for (i = 0; i < items.size() && i < limit; ++i) {
            tooltip.add(((DisplayNameStack)items.get(i)).toString());
        }
        if (items.size() <= limit) {
            return;
        }
        int count = 0;
        for (int i2 = limit; i2 < items.size(); ++i2) {
            count += ((DisplayNameStack)items.get((int)i2)).stackSize;
        }
        tooltip.add(BetterStorage.proxy.localize("tooltip.betterstorage.cardboardBox.plusMore", count));
    }

    @Override
    public ItemStack[] getContainerItemContents(ItemStack container) {
        if (StackUtils.has(container, "Items")) {
            return StackUtils.getStackContents(container, ItemBlockCardboardBox.getRows());
        }
        return null;
    }

    @Override
    public boolean canBeStoredInContainerItem(ItemStack item) {
        return !StackUtils.has(item, "Items");
    }

    public static int getRows() {
        return BetterStorage.config.cardboardBoxRows;
    }

    public static int getUses() {
        return BetterStorage.config.cardboardBoxUses;
    }

    @Override
    public boolean canDye(ItemStack stack) {
        return true;
    }

    @Override
    public int getColor(ItemStack itemstack) {
        if (this.hasColor(itemstack)) {
            NBTTagCompound compound = itemstack.func_77978_p();
            return compound.func_74762_e("color");
        }
        return 7360560;
    }

    @Override
    public boolean hasColor(ItemStack itemstack) {
        if (itemstack.func_77942_o()) {
            NBTTagCompound compound = itemstack.func_77978_p();
            return compound.func_74764_b("color");
        }
        return false;
    }

    @Override
    public void setColor(ItemStack itemstack, int colorRGB) {
        NBTTagCompound compound = itemstack.func_77942_o() ? itemstack.func_77978_p() : new NBTTagCompound();
        compound.func_74768_a("color", colorRGB);
        itemstack.func_77982_d(compound);
    }

    private static class DisplayNameStack
    implements Comparable<DisplayNameStack> {
        public final String name;
        public int stackSize;

        public DisplayNameStack(ItemStack stack) {
            this.name = stack.func_77973_b().func_77653_i(stack);
            this.stackSize = stack.func_190916_E();
        }

        public boolean matchAndAdd(ItemStack stack) {
            if (this.name.equals(stack.func_77973_b().func_77653_i(stack))) {
                this.stackSize += stack.func_190916_E();
                return true;
            }
            return false;
        }

        public String toString() {
            return this.stackSize + "x " + this.name;
        }

        @Override
        public int compareTo(DisplayNameStack other) {
            return other.stackSize - this.stackSize;
        }
    }
}

