/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.cardboard;

import io.github.tehstoneman.betterstorage.api.ICardboardItem;
import io.github.tehstoneman.betterstorage.client.renderer.Resources;
import io.github.tehstoneman.betterstorage.common.item.cardboard.ItemCardboardSheet;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardboardArmor
extends ItemArmor
implements ICardboardItem,
ISpecialArmor {
    private String name;
    private static final String[] armorText = new String[]{"Helmet", "Chestplate", "Leggings", "Boots"};

    public ItemCardboardArmor(EntityEquipmentSlot armorType) {
        super(ItemCardboardSheet.armorMaterial, 0, armorType);
    }

    public void register(String name) {
        this.name = name;
        this.func_77655_b("betterstorage." + name);
        this.setRegistryName(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return (type != null ? Resources.textureEmpty : (slot == EntityEquipmentSlot.LEGS ? Resources.textureCardboardLeggings : Resources.textureCardboardArmor)).toString();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b / 25.0, armor.func_77958_k() - armor.func_77952_i());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return armor.func_77952_i() < armor.func_77958_k() ? this.field_77879_b : 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ItemCardboardSheet.damageItem(stack, damage, entity);
    }

    @Override
    public boolean canDye(ItemStack stack) {
        return true;
    }

    public int func_82814_b(ItemStack itemstack) {
        if (this.func_82816_b_(itemstack)) {
            NBTTagCompound compound = itemstack.func_77978_p();
            return compound.func_74762_e("color");
        }
        return 7360560;
    }

    public boolean func_82816_b_(ItemStack itemstack) {
        if (itemstack.func_77942_o()) {
            NBTTagCompound compound = itemstack.func_77978_p();
            return compound.func_74764_b("color");
        }
        return false;
    }

    public void func_82813_b(ItemStack itemstack, int colorRGB) {
        NBTTagCompound compound = itemstack.func_77942_o() ? itemstack.func_77978_p() : new NBTTagCompound();
        compound.func_74768_a("color", colorRGB);
        itemstack.func_77982_d(compound);
    }
}

