/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.cardboard;

import io.github.tehstoneman.betterstorage.api.ICardboardItem;
import io.github.tehstoneman.betterstorage.common.item.cardboard.ItemCardboardSheet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardboardAxe
extends ItemAxe
implements ICardboardItem {
    private String name = "cardboard_axe";

    public ItemCardboardAxe() {
        super(Item.ToolMaterial.WOOD);
    }

    public void register() {
        this.func_77655_b("betterstorage." + this.name);
        this.setRegistryName(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean canHarvestBlock(IBlockState block, ItemStack stack) {
        return ItemCardboardSheet.canHarvestBlock(stack, super.canHarvestBlock(block, stack));
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return !ItemCardboardSheet.isEffective(stack);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState block, BlockPos pos, EntityLivingBase entity) {
        return block.func_185887_b(world, pos) > 0.0f ? ItemCardboardSheet.damageItem(stack, 1, entity) : true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        return ItemCardboardSheet.damageItem(stack, 1, player);
    }

    @Override
    public boolean canDye(ItemStack stack) {
        return true;
    }

    @Override
    public int getColor(ItemStack itemstack) {
        if (this.hasColor(itemstack)) {
            NBTTagCompound compound = itemstack.func_77978_p();
            return compound.func_74762_e("color");
        }
        return 7360560;
    }

    @Override
    public boolean hasColor(ItemStack itemstack) {
        if (itemstack.func_77942_o()) {
            NBTTagCompound compound = itemstack.func_77978_p();
            return compound.func_74764_b("color");
        }
        return false;
    }

    @Override
    public void setColor(ItemStack itemstack, int colorRGB) {
        NBTTagCompound compound = itemstack.func_77942_o() ? itemstack.func_77978_p() : new NBTTagCompound();
        compound.func_74768_a("color", colorRGB);
        itemstack.func_77982_d(compound);
    }
}

