/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.cardboard;

import io.github.tehstoneman.betterstorage.common.item.ItemBetterStorage;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;

public class ItemCardboardSheet
extends ItemBetterStorage {
    public static final Item.ToolMaterial toolMaterial = EnumHelper.addToolMaterial((String)"CARDBOARD", (int)0, (int)64, (float)2.0f, (float)-0.5f, (int)0);
    public static final ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)"CARDBOARD", (String)"betterstorage:cardboard", (int)5, (int[])new int[]{1, 2, 2, 1}, (int)0, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f);

    public ItemCardboardSheet() {
        super("cardboard_sheet");
        this.func_77625_d(8);
        toolMaterial.setRepairItem(new ItemStack((Item)this));
        armorMaterial.setRepairItem(new ItemStack((Item)this));
    }

    public static boolean isEffective(ItemStack stack) {
        return stack.func_77958_k() == 0 || stack.func_77952_i() < stack.func_77958_k();
    }

    public static boolean canHarvestBlock(ItemStack stack, boolean canHarvestDefault) {
        return ItemCardboardSheet.isEffective(stack) ? canHarvestDefault : false;
    }

    public static boolean damageItem(ItemStack stack, int damage, EntityLivingBase entity) {
        if (!ItemCardboardSheet.isEffective(stack)) {
            return true;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int numEnchants = enchants.size();
        int numLevelTotal = 0;
        Iterator iterator = enchants.values().iterator();
        while (iterator.hasNext()) {
            int enchLevel = (Integer)iterator.next();
            numLevelTotal += enchLevel;
        }
        double changeForNoDamage = -1.0 / Math.pow(numLevelTotal / 10 + 1, 2.0) + 1.0;
        changeForNoDamage = (double)(numEnchants / 10) + changeForNoDamage * (double)(1 - numEnchants / 10);
        if (entity.field_70170_p.field_73012_v.nextDouble() >= changeForNoDamage) {
            stack.func_77972_a(1, entity);
        }
        if (!ItemCardboardSheet.isEffective(stack)) {
            entity.func_70669_a(stack);
            stack.func_77964_b(stack.func_77958_k());
            stack.func_190920_e(1);
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState block, BlockPos pos, EntityLivingBase entity) {
        return block.func_185887_b(world, pos) > 0.0f ? ItemCardboardSheet.damageItem(stack, 1, entity) : true;
    }
}

