/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.tehstoneman.betterstorage.common.item.locking.ItemKeyLock;
import io.github.tehstoneman.betterstorage.utils.DyeUtils;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class KeyColorRecipe
extends ShapelessOreRecipe {
    public KeyColorRecipe(@Nullable ResourceLocation group, NonNullList<Ingredient> input, ItemStack result) {
        super(group, result, new Object[]{result});
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack outputStack = super.func_77572_b(inv);
        if (!outputStack.func_190926_b()) {
            NBTTagCompound tagCompound = outputStack.func_77942_o() ? outputStack.func_77978_p() : new NBTTagCompound();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack ingredientStack = inv.func_70301_a(i);
                if (ingredientStack.func_190926_b()) continue;
                ItemKeyLock.clearColors(ingredientStack);
                if (ingredientStack.func_77973_b() == outputStack.func_77973_b() && ingredientStack.func_77942_o()) {
                    tagCompound.func_179237_a(ingredientStack.func_77978_p());
                }
                if (!DyeUtils.isDye(ingredientStack)) continue;
                if (!tagCompound.func_74764_b("color1")) {
                    tagCompound.func_74768_a("color1", DyeUtils.getDyeColor(ingredientStack).func_193350_e());
                    continue;
                }
                if (tagCompound.func_74764_b("color2")) continue;
                tagCompound.func_74768_a("color2", DyeUtils.getDyeColor(ingredientStack).func_193350_e());
            }
            outputStack.func_77982_d(tagCompound);
        }
        return outputStack;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = Factory.parseShapeless(context, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            return new KeyColorRecipe(group.isEmpty() ? null : new ResourceLocation(group), ingredients, result);
        }

        public static NonNullList<Ingredient> parseShapeless(JsonContext context, JsonObject json) {
            NonNullList ingredients = NonNullList.func_191196_a();
            for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            return ingredients;
        }
    }
}

