/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.locking;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.api.BetterStorageEnchantment;
import io.github.tehstoneman.betterstorage.api.lock.EnumLockInteraction;
import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.ILockable;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.item.locking.ItemKeyLock;
import java.util.UUID;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemKey
extends ItemKeyLock
implements IKey {
    public ItemKey() {
        this("key");
        this.func_77656_e(64);
    }

    public ItemKey(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @Override
    public int func_77619_b() {
        return 20;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemKey.ensureHasID(stack);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isBeingHeld) {
        if (!world.field_72995_K) {
            ItemKey.ensureHasID(stack);
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && hand == EnumHand.MAIN_HAND) {
            IBlockState state;
            ItemStack stack = playerIn.func_184586_b(hand);
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity == null && (state = worldIn.func_180495_p(pos)).func_177228_b().containsKey((Object)BlockDoor.field_176523_O) && state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
                pos = pos.func_177977_b();
                tileEntity = worldIn.func_175625_s(pos);
            }
            if (tileEntity instanceof ILockable) {
                ILockable lockable = (ILockable)tileEntity;
                if (this.unlock(stack, lockable.getLock(), false)) {
                    if (playerIn.func_70093_af()) {
                        worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), lockable.getLock().func_77946_l()));
                        lockable.setLock(ItemStack.field_190927_a);
                    } else {
                        lockable.useUnlocked(playerIn);
                    }
                    return EnumActionResult.SUCCESS;
                }
                ((ILock)lockable.getLock().func_77973_b()).applyEffects(lockable.getLock(), lockable, playerIn, EnumLockInteraction.PICK);
            }
        }
        return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public static void ensureHasID(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (!tag.func_186855_b("keyid")) {
            tag.func_186854_a("keyid", UUID.randomUUID());
            stack.func_77982_d(tag);
        }
    }

    @Override
    public boolean isNormalKey() {
        return true;
    }

    @Override
    public boolean unlock(ItemStack key, ItemStack lock, boolean useAbility) {
        int roll;
        UUID keyId;
        ILock lockType = (ILock)lock.func_77973_b();
        if (lockType.getLockType() != "normal") {
            return false;
        }
        UUID lockId = ItemKey.getID(lock);
        if (lockId.equals(keyId = ItemKey.getID(key))) {
            return true;
        }
        int lockSecurity = BetterStorageEnchantment.getLevel(lock, EnchantmentBetterStorage.security);
        int unlocking = BetterStorageEnchantment.getLevel(key, EnchantmentBetterStorage.unlocking);
        int lockpicking = BetterStorageEnchantment.getLevel(key, EnchantmentBetterStorage.lockpicking);
        int morphing = BetterStorageEnchantment.getLevel(key, EnchantmentBetterStorage.morphing);
        int effectiveUnlocking = Math.max(0, unlocking - lockSecurity);
        int effectiveLockpicking = Math.max(0, lockpicking - lockSecurity);
        int effectiveMorphing = Math.max(0, morphing - lockSecurity);
        if (effectiveUnlocking > 0 && effectiveUnlocking > (roll = BetterStorage.random.nextInt(5))) {
            return true;
        }
        if (effectiveLockpicking > 0) {
            BetterStorageEnchantment.decEnchantment(key, EnchantmentBetterStorage.lockpicking, 1);
            return true;
        }
        if (effectiveMorphing > 0) {
            ItemKey.setID(key, lockId);
            BetterStorageEnchantment.decEnchantment(key, EnchantmentBetterStorage.morphing, morphing);
            return true;
        }
        return false;
    }

    @Override
    public boolean canApplyEnchantment(ItemStack key, Enchantment enchantment) {
        return true;
    }
}

