/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.locking;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.api.lock.EnumLockInteraction;
import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.client.gui.BetterStorageGUIHandler;
import io.github.tehstoneman.betterstorage.common.inventory.KeyringCapabilityProvider;
import io.github.tehstoneman.betterstorage.common.item.ItemBetterStorage;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLockable;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemKeyring
extends ItemBetterStorage
implements IKey {
    public ItemKeyring() {
        super("keyring");
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        player.openGui((Object)BetterStorage.instance, BetterStorageGUIHandler.EnumGui.KEYRING.getGuiID(), world, 0, 0, 0);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (hand == EnumHand.MAIN_HAND && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityLockable) {
            TileEntityLockable lockable = (TileEntityLockable)tileEntity;
            if (this.unlock(playerIn.func_184586_b(hand), lockable.getLock(), false)) {
                lockable.useUnlocked(playerIn);
            } else {
                ((ILock)lockable.getLock().func_77973_b()).applyEffects(lockable.getLock(), lockable, playerIn, EnumLockInteraction.PICK);
            }
        }
        return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public boolean isNormalKey() {
        return false;
    }

    @Override
    public boolean unlock(ItemStack keyring, ItemStack lock, boolean useAbility) {
        if (keyring.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler inventory = (IItemHandler)keyring.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                IKey keyType;
                ItemStack key = inventory.getStackInSlot(i);
                if (key.func_190926_b() || !(keyType = (IKey)key.func_77973_b()).unlock(key, lock, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canApplyEnchantment(ItemStack key, Enchantment enchantment) {
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new KeyringCapabilityProvider(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        for (int i = 0; i < 4; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_" + i, "inventory"));
        }
    }
}

