/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.item.locking;

import io.github.tehstoneman.betterstorage.api.BetterStorageEnchantment;
import io.github.tehstoneman.betterstorage.api.lock.EnumLockInteraction;
import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.ILockable;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.item.locking.ItemKeyLock;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLockable;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLockableDoor;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemLock
extends ItemKeyLock
implements ILock {
    public ItemLock() {
        super("lock");
        this.func_77656_e(64);
        this.func_77625_d(1);
    }

    public boolean isRepairable() {
        return true;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return material.func_77973_b() == Items.field_151043_k;
    }

    public boolean func_77645_m() {
        return true;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemLock.ensureHasID(stack);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isBeingHeld) {
        if (!world.field_72995_K) {
            ItemLock.ensureHasID(stack);
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            TileEntity lockable;
            TileEntity tileEntity;
            ItemStack stack = playerIn.func_184586_b(hand);
            IBlockState blockState = worldIn.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block == Blocks.field_150454_av) {
                if (blockState.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
                    pos = pos.func_177977_b();
                    blockState = worldIn.func_180495_p(pos);
                    block = blockState.func_177230_c();
                }
                worldIn.func_175656_a(pos, BetterStorageBlocks.LOCKABLE_DOOR.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, blockState.func_177229_b((IProperty)BlockDoor.field_176520_a)).func_177226_a((IProperty)BlockDoor.field_176519_b, blockState.func_177229_b((IProperty)BlockDoor.field_176519_b)).func_177226_a((IProperty)BlockDoor.field_176521_M, blockState.func_177229_b((IProperty)BlockDoor.field_176521_M)).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER));
                worldIn.func_175656_a(pos.func_177984_a(), BetterStorageBlocks.LOCKABLE_DOOR.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, blockState.func_177229_b((IProperty)BlockDoor.field_176520_a)).func_177226_a((IProperty)BlockDoor.field_176519_b, blockState.func_177229_b((IProperty)BlockDoor.field_176519_b)).func_177226_a((IProperty)BlockDoor.field_176521_M, blockState.func_177229_b((IProperty)BlockDoor.field_176521_M)).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER));
                tileEntity = worldIn.func_175625_s(pos);
                if (tileEntity instanceof TileEntityLockableDoor && (lockable = (TileEntityLockableDoor)tileEntity).isLockValid(stack)) {
                    lockable.setLock(stack.func_77946_l());
                    if (!playerIn.func_184812_l_()) {
                        playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
            if ((tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityLockable && (lockable = (TileEntityLockable)tileEntity).isLockValid(stack) && lockable.getLock().func_190926_b()) {
                lockable.setLock(stack.func_77946_l());
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public static void ensureHasID(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (!tag.func_186855_b("keyid")) {
            tag.func_186854_a("keyid", UUID.randomUUID());
            stack.func_77982_d(tag);
        }
    }

    @Override
    public String getLockType() {
        return "normal";
    }

    @Override
    public void onUnlock(ItemStack lock, ItemStack key, ILockable lockable, EntityPlayer player, boolean success) {
        if (success) {
            return;
        }
        EnumLockInteraction interaction = key != null ? EnumLockInteraction.PICK : EnumLockInteraction.OPEN;
        this.applyEffects(lock, lockable, player, interaction);
    }

    @Override
    public void applyEffects(ItemStack lock, ILockable lockable, EntityPlayer player, EnumLockInteraction interaction) {
        int shock = BetterStorageEnchantment.getLevel(lock, EnchantmentBetterStorage.shock);
        int trigger = BetterStorageEnchantment.getLevel(lock, EnchantmentBetterStorage.trigger);
        if (shock > 0) {
            boolean open = interaction == EnumLockInteraction.OPEN;
            boolean pick = interaction == EnumLockInteraction.PICK;
            int damage = shock;
            if (pick) {
                damage *= 3;
            }
            player.func_70097_a(DamageSource.field_76376_m, (float)damage);
            if (shock >= 3 && !open) {
                player.func_70015_d(3);
            }
        }
        if (trigger > 0) {
            lockable.applyTrigger();
        }
    }

    @Override
    public boolean canApplyEnchantment(ItemStack key, Enchantment enchantment) {
        return true;
    }
}

