/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.item.cardboard.ItemBlockCardboardBox;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityContainer;
import io.github.tehstoneman.betterstorage.utils.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;

public class TileEntityCardboardBox
extends TileEntityContainer {
    public int uses = 1;
    public boolean destroyed = false;
    public int color = -1;

    protected boolean canPickUp() {
        return this.uses >= 0 || ItemBlockCardboardBox.getUses() == 0;
    }

    protected void onItemDropped(ItemStack stack) {
        if (ItemBlockCardboardBox.getUses() > 0) {
            StackUtils.set(stack, this.uses, "uses");
        }
        if (this.getCustomTitle() != null) {
            stack.func_151001_c(this.getCustomTitle());
        }
    }

    @Override
    public String getName() {
        return "container.betterstorage.cardboard_box";
    }

    @Override
    public int getRows() {
        return ItemBlockCardboardBox.getRows();
    }

    @Override
    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlaced(player, stack);
        this.uses = ItemBlockCardboardBox.getUses();
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound.func_74764_b("Inventory")) {
                this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
            }
            if (this.uses > 0 && compound.func_74764_b("uses")) {
                this.uses = Math.min(this.uses, compound.func_74762_e("uses"));
            }
            if (compound.func_74764_b("color")) {
                this.color = compound.func_74762_e("color");
            }
        }
        this.func_70296_d();
    }

    @Override
    public void onBlockDestroyed() {
        if (!this.canPickUp() || this.destroyed) {
            return;
        }
        boolean empty = this.isEmpty(this.inventory);
        if (!empty) {
            if (this.uses >= 0) {
                --this.uses;
            }
            if (!this.canPickUp()) {
                this.destroyed = true;
                this.dropContents();
                return;
            }
        }
        if (!empty || !this.brokenInCreative) {
            ItemStack stack = new ItemStack((Block)BetterStorageBlocks.CARDBOARD_BOX);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("uses", this.uses);
            if (this.color >= 0) {
                compound.func_74768_a("color", this.color);
            }
            if (!empty) {
                compound.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
            }
            stack.func_77982_d(compound);
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), stack);
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        compound.func_74768_a("uses", this.uses);
        if (this.color >= 0) {
            compound.func_74768_a("color", this.color);
        }
        return compound;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        if (compound.func_74764_b("uses")) {
            this.uses = compound.func_74762_e("uses");
        }
        if (compound.func_74764_b("color")) {
            this.color = compound.func_74762_e("color");
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        int n = this.uses = compound.func_74764_b("uses") ? compound.func_74762_e("uses") : ItemBlockCardboardBox.getUses();
        if (compound.func_74764_b("color")) {
            this.color = compound.func_74762_e("color");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (ItemBlockCardboardBox.getUses() > 0) {
            compound.func_74768_a("uses", this.uses);
        }
        if (this.color >= 0) {
            compound.func_74768_a("color", this.color);
        }
        return compound;
    }

    public int getColor() {
        if (this.color < 0) {
            return 7360560;
        }
        return this.color;
    }
}

