/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.common.inventory.ConnectedStackHandler;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityConnectable
extends TileEntityContainer {
    protected BlockPos connectedPos = null;

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.isMain()) {
            if (this.isConnected() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)((Object)new ConnectedStackHandler(this.inventory, this.getConnectedTileEntity().inventory));
            }
            return super.getCapability(capability, facing);
        }
        return this.getMainTileEntity().getCapability(capability, facing);
    }

    public EnumFacing getOrientation() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        EnumFacing orientation = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        return orientation != null ? orientation : EnumFacing.NORTH;
    }

    public BlockPos getConnected() {
        return this.connectedPos;
    }

    public void setConnected(BlockPos connected) {
        this.connectedPos = connected;
    }

    public abstract EnumFacing[] getPossibleNeighbors();

    public boolean isConnected() {
        return this.getConnected() != null;
    }

    public boolean isMain() {
        if (this.isConnected()) {
            BlockPos connected = this.getConnected();
            return connected.func_177958_n() > this.field_174879_c.func_177958_n() || connected.func_177956_o() > this.field_174879_c.func_177956_o() || connected.func_177952_p() > this.field_174879_c.func_177952_p();
        }
        return true;
    }

    public TileEntityConnectable getMainTileEntity() {
        if (this.isMain()) {
            return this;
        }
        TileEntityConnectable connectable = this.getConnectedTileEntity();
        if (connectable != null) {
            return connectable;
        }
        if (BetterStorage.config.enableWarningMessages) {
            BetterStorage.logger.warn("getConnectedTileEntity() returned null in getMainTileEntity(). Location: {},{},{}", (Object)this.field_174879_c.func_177958_n(), (Object)this.field_174879_c.func_177956_o(), (Object)this.field_174879_c.func_177952_p());
        }
        return this;
    }

    public TileEntityConnectable getConnectedTileEntity() {
        if (this.func_145831_w() == null || !this.isConnected()) {
            return null;
        }
        TileEntity tileEntity = this.func_145831_w().func_175625_s(this.getConnected());
        return tileEntity instanceof TileEntityConnectable ? (TileEntityConnectable)tileEntity : null;
    }

    public boolean canConnect(TileEntityConnectable connectable) {
        return connectable != null && !this.isConnected() && !connectable.isConnected() && this.func_145838_q() == connectable.func_145838_q() && this.getOrientation() == connectable.getOrientation();
    }

    public void checkForConnections() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        for (EnumFacing dir : this.getPossibleNeighbors()) {
            TileEntityConnectable connectable;
            TileEntity tileentity;
            if (this.isConnected() || !((tileentity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir))) instanceof TileEntityConnectable) || !this.canConnect(connectable = (TileEntityConnectable)tileentity)) continue;
            this.setConnected(connectable.func_174877_v());
            connectable.setConnected(this.func_174877_v());
            this.markForUpdate();
            connectable.markForUpdate();
        }
    }

    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        TileEntityConnectable connectable = this.getConnectedTileEntity();
        this.setConnected(null);
        if (connectable != null) {
            connectable.setConnected(null);
            connectable.markForUpdate();
        } else if (BetterStorage.config.enableWarningMessages) {
            BetterStorage.logger.warn("getConnectedTileEntity() returned null in disconnect(). Location: {},{},{}", (Object)this.field_174879_c.func_177958_n(), (Object)this.field_174879_c.func_177956_o(), (Object)this.field_174879_c.func_177952_p());
        }
    }

    protected abstract String getConnectableName();

    @Override
    public final String getName() {
        return this.getConnectableName() + (this.isConnected() ? "_large" : "");
    }

    @Override
    protected boolean doesSyncPlayers() {
        return true;
    }

    @Override
    public int getRows() {
        if (this.isConnected()) {
            return super.getRows() * 2;
        }
        return super.getRows();
    }

    @Override
    public final void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlaced(player, stack);
        this.checkForConnections();
    }

    @Override
    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        this.disconnect();
    }

    protected boolean isAccessible() {
        return true;
    }

    @Override
    public int getComparatorSignalStrength() {
        if (this.func_145831_w().field_72995_K) {
            return 0;
        }
        if (!this.isConnected()) {
            return super.getComparatorSignalStrength();
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < this.inventory.getSlots(); ++j) {
            ItemStack itemstack = this.inventory.getStackInSlot(j);
            if (itemstack == null) continue;
            f += (float)itemstack.func_190916_E() / (float)itemstack.func_77976_d();
            ++i;
        }
        ItemStackHandler otherInventory = this.getConnectedTileEntity().inventory;
        for (int j = 0; j < otherInventory.getSlots(); ++j) {
            ItemStack itemstack = otherInventory.getStackInSlot(j);
            if (itemstack == null) continue;
            f += (float)itemstack.func_190916_E() / (float)itemstack.func_77976_d();
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)(this.inventory.getSlots() + otherInventory.getSlots())) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        if (this.isConnected()) {
            if (!this.isMain()) {
                return;
            }
            TileEntityConnectable connectable = this.getConnectedTileEntity();
            if (connectable != null) {
                x = (x + (double)connectable.field_174879_c.func_177958_n() + 0.5) / 2.0;
                z = (z + (double)connectable.field_174879_c.func_177952_p() + 0.5) / 2.0;
                this.lidAngle = Math.max(this.lidAngle, connectable.lidAngle);
            }
        }
        float pitch = this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f;
        if (this.lidAngle > 0.0f && this.prevLidAngle == 0.0f) {
            this.func_145831_w().func_184148_a((EntityPlayer)null, x, y, z, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, pitch);
        }
        if (this.lidAngle < 0.5f && this.prevLidAngle >= 0.5f) {
            this.func_145831_w().func_184148_a((EntityPlayer)null, x, y, z, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, pitch);
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.getName());
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.isConnected() && this.func_145831_w() != null) {
            TileEntityConnectable connected = this.getConnectedTileEntity();
            connected.func_145836_u();
            this.func_145831_w().func_175646_b(connected.func_174877_v(), (TileEntity)this);
            if (connected.func_145838_q() != Blocks.field_150350_a) {
                this.func_145831_w().func_175666_e(connected.func_174877_v(), connected.func_145838_q());
            }
        }
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        if (this.getConnected() != null) {
            compound.func_74772_a("connected", this.getConnected().func_177986_g());
        }
        return compound;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound compound) {
        super.handleUpdateTag(compound);
        this.connectedPos = compound.func_74764_b("connected") ? BlockPos.func_177969_a((long)compound.func_74763_f("connected")) : null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.getConnected() != null) {
            compound.func_74772_a("connected", this.getConnected().func_177986_g());
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("connected")) {
            this.setConnected(BlockPos.func_177969_a((long)compound.func_74763_f("connected")));
        } else {
            this.setConnected(null);
        }
    }
}

