/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.client.gui.BetterStorageGUIHandler;
import io.github.tehstoneman.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityContainer
extends TileEntity
implements ITickable {
    public ItemStackHandler inventory;
    private String customTitle = null;
    private int playersUsing = 0;
    protected boolean brokenInCreative = false;
    public int ticksExisted = 0;
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;
    private int redstonePower = 0;
    private boolean compAccessedOnLoad = false;
    private boolean compAccessed = false;
    private boolean compContentsChanged = false;

    public TileEntityContainer() {
        int size = this.getSizeContents();
        this.inventory = size > 0 ? new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                TileEntityContainer.this.func_70296_d();
            }
        } : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getColumns() {
        return 9;
    }

    public int getRows() {
        return 3;
    }

    protected int getSizeContents() {
        return this.getColumns() * this.getRows();
    }

    public abstract String getName();

    public final int getPlayersUsing() {
        return this.playersUsing;
    }

    public boolean canPlayerUseContainer(EntityPlayer player) {
        return player.func_174818_b(this.field_174879_c) <= 64.0;
    }

    public String getContainerTitle() {
        return this.hasCustomTitle() ? this.getCustomTitle() : this.getName();
    }

    public String getCustomTitle() {
        return this.customTitle;
    }

    public boolean hasCustomTitle() {
        return this.getCustomTitle() != null;
    }

    public boolean shouldLocalizeTitle() {
        return !this.hasCustomTitle();
    }

    public boolean canSetCustomTitle() {
        return true;
    }

    public void setCustomTitle(String title) {
        if (this.canSetCustomTitle()) {
            this.customTitle = title;
        }
    }

    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        if (stack.func_82837_s()) {
            this.setCustomTitle(stack.func_82833_r());
        }
    }

    public boolean onBlockActivated(BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.func_145831_w().field_72995_K) {
            return true;
        }
        if (!this.canPlayerUseContainer(player)) {
            return false;
        }
        player.openGui((Object)"betterstorage", BetterStorageGUIHandler.EnumGui.GENERAL.getGuiID(), this.func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public ItemStack onPickBlock(ItemStack block, RayTraceResult target) {
        return block;
    }

    public boolean onBlockBreak(EntityPlayer player) {
        this.brokenInCreative = player.field_71075_bZ.field_75098_d;
        return true;
    }

    public void onNeighborUpdate(Block neighborBlock) {
        if (this.acceptsRedstoneSignal() && neighborBlock.func_149744_f(null)) {
            this.checkForRedstoneChange();
        }
    }

    public void onBlockDestroyed() {
        this.dropContents();
        this.brokenInCreative = false;
    }

    public void dropContents() {
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), stack));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onBlockRenderAsItem(ItemStack stack) {
    }

    protected boolean acceptsRedstoneSignal() {
        return false;
    }

    protected boolean requiresStrongSignal() {
        return false;
    }

    public int getRedstonePower() {
        return this.redstonePower;
    }

    public boolean isRedstonePowered() {
        return this.getRedstonePower() > 0;
    }

    protected void checkForRedstoneChange() {
        int previousPower = this.redstonePower;
        int n = this.redstonePower = this.requiresStrongSignal() ? this.getStrongRedstoneSignal() : this.getWeakRedstoneSignal();
        if (this.redstonePower == previousPower) {
            return;
        }
        this.onRedstonePowerChanged(previousPower, this.redstonePower);
        if (previousPower <= 0) {
            this.onRedstoneActivated();
        }
        if (this.redstonePower <= 0) {
            this.onRedstoneDeactivated();
        }
    }

    protected void onRedstonePowerChanged(int previousPower, int currentPower) {
    }

    protected void onRedstoneActivated() {
    }

    protected void onRedstoneDeactivated() {
    }

    protected int getStrongRedstoneSignal() {
        return this.func_145831_w().func_175676_y(this.field_174879_c);
    }

    protected int getWeakRedstoneSignal() {
        return this.func_145831_w().func_175687_A(this.field_174879_c);
    }

    protected boolean hasComparatorAccessed() {
        return this.compAccessed;
    }

    protected boolean hasContentsChanged() {
        return this.compContentsChanged;
    }

    public int getComparatorSignalStrength() {
        if (this.func_145831_w().field_72995_K) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < this.inventory.getSlots(); ++j) {
            ItemStack itemstack = this.inventory.getStackInSlot(j);
            if (itemstack == null) continue;
            f += (float)itemstack.func_190916_E() / (float)itemstack.func_77976_d();
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)this.inventory.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    protected void markComparatorAccessed() {
        this.compAccessed = true;
    }

    protected void markContentsChanged() {
        this.compContentsChanged = true;
    }

    protected int getComparatorSignalStengthInternal() {
        return this instanceof IInventory ? Container.func_94526_b((IInventory)((IInventory)this)) : 0;
    }

    protected void comparatorUpdateAndReset() {
        this.compAccessed = false;
        this.compContentsChanged = false;
        WorldUtils.notifyBlocksAround(this.func_145831_w(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    public void markDirtySuper() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        this.func_145831_w().func_175646_b(new BlockPos((Vec3i)this.field_174879_c), (TileEntity)this);
        if (this.hasComparatorAccessed()) {
            this.markContentsChanged();
        }
    }

    public void func_145829_t() {
        if (this.compAccessedOnLoad) {
            this.markComparatorAccessed();
            this.compAccessedOnLoad = false;
        }
    }

    protected boolean doesSyncPlayers() {
        return false;
    }

    protected boolean syncPlayersUsing() {
        return !this.func_145831_w().field_72995_K && this.doesSyncPlayers() && (this.ticksExisted + this.field_174879_c.func_177958_n() + this.field_174879_c.func_177956_o() + this.field_174879_c.func_177952_p() & 0xFF) == 0;
    }

    private void doSyncPlayersUsing(int playersUsing) {
        if (!this.doesSyncPlayers()) {
            return;
        }
        this.func_145831_w().func_175641_c(this.field_174879_c, this.func_145838_q(), 0, playersUsing);
    }

    public boolean func_145842_c(int event, int value) {
        if (event == 0) {
            this.playersUsing = value;
        }
        return true;
    }

    public void onContainerOpened() {
        this.doSyncPlayersUsing(++this.playersUsing);
    }

    public void onContainerClosed() {
        this.doSyncPlayersUsing(--this.playersUsing);
    }

    protected float getLidSpeed() {
        return 0.1f;
    }

    public void func_73660_a() {
        if (this.ticksExisted++ == 0) {
            this.checkForRedstoneChange();
        }
        if (this.hasComparatorAccessed() && this.hasContentsChanged()) {
            this.comparatorUpdateAndReset();
        }
        this.prevLidAngle = this.lidAngle;
        if (this.playersUsing > 0) {
            if (this.lidAngle < 1.0f) {
                this.lidAngle = Math.min(1.0f, this.lidAngle + this.getLidSpeed());
            }
        } else if (this.lidAngle > 0.0f) {
            this.lidAngle = Math.max(0.0f, this.lidAngle - this.getLidSpeed());
        }
    }

    public boolean isEmpty(ItemStackHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        if (this.customTitle != null) {
            compound.func_74778_a("CustomName", this.customTitle);
        }
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
        this.func_145831_w().func_175704_b(this.field_174879_c.func_177982_a(-1, -1, -1), this.field_174879_c.func_177982_a(1, 1, 1));
    }

    public void handleUpdateTag(NBTTagCompound compound) {
        super.handleUpdateTag(compound);
        if (compound.func_74764_b("CustomName")) {
            this.customTitle = compound.func_74779_i("CustomName");
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("CustomName")) {
            this.customTitle = compound.func_74779_i("CustomName");
        }
        if (compound.func_74764_b("Inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        }
        if (compound.func_74767_n("ComparatorAccessed")) {
            this.compAccessedOnLoad = true;
        }
        if (this.acceptsRedstoneSignal()) {
            this.redstonePower = compound.func_74771_c("RedstonePower");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.customTitle != null) {
            compound.func_74778_a("CustomName", this.customTitle);
        }
        if (this.inventory != null) {
            compound.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        }
        if (this.hasComparatorAccessed()) {
            compound.func_74757_a("ComparatorAccessed", true);
        }
        if (this.acceptsRedstoneSignal()) {
            compound.func_74774_a("RedstonePower", (byte)this.redstonePower);
        }
        return compound;
    }

    public void markForUpdate() {
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
        this.func_70296_d();
    }
}

