/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.inventory.CrateStackHandler;
import io.github.tehstoneman.betterstorage.common.inventory.Region;
import io.github.tehstoneman.betterstorage.common.world.CrateStackCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityCrate
extends TileEntity {
    public static final int slotsPerCrate = 18;
    public static final int maxCrates = 125;
    public static final int maxPerSide = 5;
    private UUID pileID;
    private String customTitle;
    private int numCrates;
    private int capacity;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == null || BetterStorage.config.enableCrateInventoryInterface)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == null || BetterStorage.config.enableCrateInventoryInterface)) {
            return (T)((Object)this.getCrateStackHandler());
        }
        return (T)super.getCapability(capability, facing);
    }

    public void onBlockPlaced(EntityLivingBase placer, ItemStack stack) {
        if (!this.func_145831_w().field_72995_K && this.pileID == null) {
            this.getCrateStackHandler().addCrate(this);
            this.func_70296_d();
        }
    }

    public CrateStackHandler getCrateStackHandler() {
        CrateStackCollection collection = CrateStackCollection.getCollection(this.func_145831_w());
        if (this.func_145831_w().field_72995_K) {
            return new CrateStackHandler(this.getCapacity());
        }
        CrateStackHandler handler = collection.getCratePile(this.pileID);
        handler.sendUpdatesTo(this);
        return handler;
    }

    public UUID getPileID() {
        if (this.pileID == null) {
            CrateStackCollection collection = CrateStackCollection.getCollection(this.func_145831_w());
            CrateStackHandler handler = collection.createCratePile();
            this.pileID = handler.getPileID();
        }
        return this.pileID;
    }

    public void setPileID(UUID pileID) {
        this.pileID = pileID;
        this.func_70296_d();
    }

    private void checkPileConnections(UUID pileID) {
        TileEntityCrate crateAbove;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        TileEntity tileEntity = this.func_145831_w().func_175625_s(this.field_174879_c.func_177984_a());
        if (tileEntity instanceof TileEntityCrate && (crateAbove = (TileEntityCrate)tileEntity) != null && crateAbove.getPileID().equals(pileID)) {
            CrateStackHandler handler = this.getCrateStackHandler();
            NonNullList<ItemStack> overflow = handler.removeCrate(crateAbove);
            if (!overflow.isEmpty()) {
                for (ItemStack stack : overflow) {
                    if (stack.func_190926_b()) continue;
                    this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), stack));
                }
            }
            this.func_145831_w().func_175698_g(this.field_174879_c.func_177984_a());
            this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)x, (double)(y + 1), (double)z, new ItemStack((Block)BetterStorageBlocks.CRATE)));
        }
        CrateStackHandler handler = this.getCrateStackHandler();
        if (this.getNumCrates() <= 0 || y != handler.getRegion().posMin.func_177956_o()) {
            return;
        }
        List<HashSet<TileEntityCrate>> crateSets = this.getCrateSets(x, y, z, pileID);
        if (crateSets.size() <= 1) {
            handler.trimRegion(this.func_145831_w());
            this.notifyRegionUpdate(handler.getRegion(), this.getPileID());
            return;
        }
        CrateStackCollection collection = CrateStackCollection.getCollection(this.func_145831_w());
        for (int i = 1; i < crateSets.size(); ++i) {
            HashSet<TileEntityCrate> set = crateSets.get(i);
            CrateStackHandler newHandler = collection.createCratePile();
            int numCrates = set.size();
            for (TileEntityCrate newCrate : set) {
                newHandler.addCrate(newCrate);
                NonNullList<ItemStack> overflow = handler.removeCrate(newCrate);
                if (!overflow.isEmpty()) {
                    for (ItemStack stack : overflow) {
                        if (stack.func_190926_b()) continue;
                        newHandler.addItems(stack);
                    }
                }
                while ((newCrate = (TileEntityCrate)this.func_145831_w().func_175625_s(newCrate.func_174877_v().func_177984_a())) != null) {
                    newHandler.addCrate(newCrate);
                    ++numCrates;
                }
            }
            this.notifyRegionUpdate(newHandler.getRegion(), newHandler.getPileID());
        }
        handler.trimRegion(this.func_145831_w());
        this.notifyRegionUpdate(handler.getRegion(), this.getPileID());
    }

    private List<HashSet<TileEntityCrate>> getCrateSets(int x, int y, int z, UUID pileID) {
        ArrayList<HashSet<TileEntityCrate>> crateSets = new ArrayList<HashSet<TileEntityCrate>>();
        int checkedCrates = 0;
        block0: for (EnumFacing dir : EnumFacing.field_176754_o) {
            int nx = x + dir.func_82601_c();
            int nz = z + dir.func_82599_e();
            TileEntity tileEntity = this.func_145831_w().func_175625_s(this.field_174879_c.func_177971_a(dir.func_176730_m()));
            if (tileEntity instanceof TileEntityCrate) {
                TileEntityCrate neighborCrate = (TileEntityCrate)tileEntity;
                if (neighborCrate == null || !neighborCrate.getPileID().equals(pileID)) continue;
                for (HashSet hashSet : crateSets) {
                    if (!hashSet.contains((Object)neighborCrate)) continue;
                    continue block0;
                }
                HashSet<TileEntityCrate> set = new HashSet<TileEntityCrate>();
                set.add(neighborCrate);
                for (EnumFacing ndir : EnumFacing.field_176754_o) {
                    this.checkConnections(nx + ndir.func_82601_c(), y, nz + ndir.func_82599_e(), pileID, set);
                }
                crateSets.add(set);
                checkedCrates += set.size();
            }
            if (checkedCrates >= this.getNumCrates()) break;
        }
        return crateSets;
    }

    private void checkConnections(int x, int y, int z, UUID pileID, HashSet<TileEntityCrate> set) {
        TileEntity tileEntity = this.func_145831_w().func_175625_s(new BlockPos(x, y, z));
        if (tileEntity instanceof TileEntityCrate) {
            TileEntityCrate crate = (TileEntityCrate)tileEntity;
            if (!pileID.equals(crate.getPileID()) || set.contains((Object)crate)) {
                return;
            }
            set.add(crate);
        }
        for (EnumFacing ndir : EnumFacing.field_176754_o) {
            this.checkConnections(x + ndir.func_82601_c(), y, z + ndir.func_82599_e(), pileID, set);
        }
    }

    public boolean attemptConnect(EnumFacing side) {
        TileEntityCrate crateClicked;
        CrateStackHandler handler;
        if (this.func_145831_w().field_72995_K || side == EnumFacing.UP) {
            return false;
        }
        BlockPos neighbourPos = this.field_174879_c.func_177971_a(side.func_176730_m());
        TileEntity tileEntity = this.func_145831_w().func_175625_s(neighbourPos);
        if (tileEntity instanceof TileEntityCrate && (handler = (crateClicked = (TileEntityCrate)tileEntity).getCrateStackHandler()).canAdd(this)) {
            handler.addCrate(this);
            this.pileID = handler.getPileID();
            this.notifyRegionUpdate(handler.getRegion(), this.pileID);
            this.func_70296_d();
            crateClicked.func_70296_d();
            return true;
        }
        return false;
    }

    public void notifyRegionUpdate(Region region, UUID pileID) {
        for (BlockPos blockPos : BlockPos.func_177980_a((BlockPos)region.posMin, (BlockPos)region.posMax)) {
            TileEntity te = this.func_145831_w().func_175625_s(blockPos);
            if (!(te instanceof TileEntityCrate) || !((TileEntityCrate)te).pileID.equals(pileID)) continue;
            IBlockState state = this.func_145831_w().func_180495_p(blockPos);
            this.func_145831_w().func_184138_a(blockPos, state, state, 3);
        }
    }

    public void setCustomTitle(String displayName) {
        this.customTitle = displayName;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.checkPileConnections(this.getPileID());
    }

    public int getNumCrates() {
        if (this.func_145831_w().field_72995_K) {
            return this.numCrates;
        }
        return this.getCrateStackHandler().getNumCrates();
    }

    public void setNumCrates(int numCrates) {
        this.getCrateStackHandler().setNumCrates(numCrates);
        this.func_70296_d();
    }

    public int getCapacity() {
        if (this.func_145831_w().field_72995_K) {
            return this.capacity;
        }
        return this.getCrateStackHandler().getCapacity();
    }

    public int getComparatorSignalStrength() {
        if (this.func_145831_w().field_72995_K) {
            return 0;
        }
        CrateStackHandler handler = this.getCrateStackHandler();
        return handler.getOccupiedSlots() > 0 ? 1 + handler.getOccupiedSlots() * 14 / handler.getCapacity() : 0;
    }

    public void func_70296_d() {
        CrateStackCollection collection = CrateStackCollection.getCollection(this.func_145831_w());
        collection.func_76185_a();
        super.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        if (this.pileID != null) {
            compound.func_186854_a("PileID", this.pileID);
        }
        compound.func_74768_a("NumCrates", this.getNumCrates());
        compound.func_74768_a("Capacity", this.getCapacity());
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        if (compound.func_186855_b("PileID")) {
            this.pileID = compound.func_186857_a("PileID");
        }
        this.numCrates = compound.func_74762_e("NumCrates");
        this.capacity = compound.func_74762_e("Capacity");
        this.func_145831_w().func_175704_b(this.field_174879_c.func_177982_a(-1, -1, -1), this.field_174879_c.func_177982_a(1, 1, 1));
    }

    public void handleUpdateTag(NBTTagCompound compound) {
        super.handleUpdateTag(compound);
        if (compound.func_186855_b("PileID")) {
            this.pileID = compound.func_186857_a("PileID");
        }
        this.numCrates = compound.func_74762_e("NumCrates");
        this.capacity = compound.func_74762_e("Capacity");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.pileID != null) {
            compound.func_186854_a("PileID", this.pileID);
        }
        compound.func_74768_a("NumCrates", this.getNumCrates());
        compound.func_74768_a("Capacity", this.getCapacity());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_186855_b("PileID")) {
            this.pileID = compound.func_186857_a("PileID");
        }
        this.numCrates = compound.func_74762_e("NumCrates");
        this.capacity = compound.func_74762_e("Capacity");
    }
}

