/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.api.EnumReinforced;
import io.github.tehstoneman.betterstorage.api.lock.EnumLockInteraction;
import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.ILockable;
import io.github.tehstoneman.betterstorage.attachment.Attachments;
import io.github.tehstoneman.betterstorage.attachment.IHasAttachments;
import io.github.tehstoneman.betterstorage.attachment.LockAttachment;
import io.github.tehstoneman.betterstorage.client.gui.BetterStorageGUIHandler;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityConnectable;
import java.security.InvalidParameterException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityLockable
extends TileEntityConnectable
implements ILockable,
IHasAttachments {
    private boolean powered;
    public EnumReinforced material;
    public LockAttachment lockAttachment;
    protected Attachments attachments = new Attachments(this);

    public TileEntityLockable() {
        if (!this.canHaveLock()) {
            return;
        }
        this.lockAttachment = this.attachments.add(LockAttachment.class);
        this.lockAttachment.setScale(0.5f, 1.5f);
        this.setAttachmentPosition();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null && !this.getLock().func_190926_b()) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    public boolean canHaveLock() {
        return true;
    }

    protected ItemStack getLockInternal() {
        return this.canHaveLock() ? this.lockAttachment.getItem() : ItemStack.field_190927_a;
    }

    protected void setLockInternal(ItemStack lock) {
        this.lockAttachment.setItem(lock);
    }

    public EnumReinforced getMaterial() {
        if (this.material == null) {
            this.material = EnumReinforced.IRON;
        }
        return this.material;
    }

    public void setMaterial(EnumReinforced reinforcedMaterial) {
        this.material = reinforcedMaterial;
        this.func_70296_d();
    }

    public abstract void setAttachmentPosition();

    @Override
    public Attachments getAttachments() {
        return ((TileEntityLockable)this.getMainTileEntity()).attachments;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.attachments.update();
    }

    @Override
    public boolean onBlockActivated(BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K && this.canHaveLock() && !this.getLock().func_190926_b()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!(stack.func_77973_b() instanceof IKey) && !this.canPlayerUseContainer(player)) {
                ((ILock)this.getLock().func_77973_b()).applyEffects(this.getLock(), this, player, EnumLockInteraction.OPEN);
            }
            return false;
        }
        return super.onBlockActivated(pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean canPlayerUseContainer(EntityPlayer player) {
        return super.canPlayerUseContainer(player) && (this.getLock().func_190926_b() || this.canUse(player));
    }

    @Override
    public void dropContents() {
        super.dropContents();
        if (!this.canHaveLock()) {
            return;
        }
        ItemStack stack = this.getLock();
        if (!stack.func_190926_b()) {
            this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), stack));
        }
        this.setLock(ItemStack.field_190927_a);
    }

    @Override
    protected boolean isAccessible() {
        return this.getLock() == null;
    }

    @Override
    public boolean canConnect(TileEntityConnectable connectable) {
        if (!(connectable instanceof TileEntityLockable)) {
            return false;
        }
        TileEntityLockable lockable = (TileEntityLockable)connectable;
        return super.canConnect(connectable) && this.material == lockable.material && this.getLock() == ItemStack.field_190927_a && lockable.getLock() == ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getLock() {
        return ((TileEntityLockable)this.getMainTileEntity()).getLockInternal();
    }

    @Override
    public boolean isLockValid(ItemStack lock) {
        return lock.func_190926_b() || this.canHaveLock() && lock.func_77973_b() instanceof ILock;
    }

    @Override
    public void setLock(ItemStack lock) {
        if (!this.isLockValid(lock)) {
            throw new InvalidParameterException("Can't set lock to " + lock + ".");
        }
        TileEntityLockable main = (TileEntityLockable)this.getMainTileEntity();
        main.setLockInternal(lock);
        main.markForUpdate();
        this.func_70296_d();
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return this.getMainTileEntity().getPlayersUsing() > 0;
    }

    @Override
    public void useUnlocked(EntityPlayer player) {
        player.openGui((Object)"betterstorage", BetterStorageGUIHandler.EnumGui.GENERAL.getGuiID(), this.func_145831_w(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    @Override
    public void applyTrigger() {
        this.setPowered(true);
    }

    public boolean isPowered() {
        return ((TileEntityLockable)this.getMainTileEntity()).powered;
    }

    public void setPowered(boolean powered) {
        TileEntityLockable chest = (TileEntityLockable)this.getMainTileEntity();
        if (chest != this) {
            chest.setPowered(powered);
            return;
        }
        if (this.powered == powered) {
            return;
        }
        this.powered = powered;
        Block block = this.func_145838_q();
        if (powered) {
            this.func_145831_w().func_180497_b(this.field_174879_c, block, 10, 1);
        }
        this.func_145831_w().func_175685_c(this.field_174879_c, block, true);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        ItemStack lock;
        NBTTagCompound compound = super.func_189517_E_();
        if (this.material != null) {
            compound.func_74778_a("material", this.material.func_176610_l());
        }
        if (this.canHaveLock() && !(lock = this.getLockInternal()).func_190926_b()) {
            compound.func_74782_a("lock", (NBTBase)lock.func_77955_b(new NBTTagCompound()));
        }
        return compound;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound compound) {
        super.handleUpdateTag(compound);
        if (compound.func_74764_b("material")) {
            this.material = EnumReinforced.byName(compound.func_74779_i("material"));
        }
        if (this.canHaveLock()) {
            ItemStack itemStack = ItemStack.field_190927_a;
            if (compound.func_74764_b("lock")) {
                itemStack = new ItemStack(compound.func_74775_l("lock"));
            }
            this.setLockInternal(itemStack);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ItemStack lock;
        super.func_189515_b(compound);
        if (this.material != null) {
            compound.func_74778_a("material", this.material.func_176610_l());
        }
        if (this.canHaveLock() && !(lock = this.getLockInternal()).func_190926_b()) {
            compound.func_74782_a("lock", (NBTBase)lock.func_77955_b(new NBTTagCompound()));
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("material")) {
            this.material = EnumReinforced.byName(compound.func_74779_i("material"));
        }
        if (this.canHaveLock()) {
            ItemStack itemStack = ItemStack.field_190927_a;
            if (compound.func_74764_b("lock")) {
                itemStack = new ItemStack(compound.func_74775_l("lock"));
            }
            this.setLockInternal(itemStack);
        }
    }
}

