/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.api.lock.EnumLockInteraction;
import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.ILockable;
import io.github.tehstoneman.betterstorage.attachment.Attachments;
import io.github.tehstoneman.betterstorage.attachment.IHasAttachments;
import io.github.tehstoneman.betterstorage.attachment.LockAttachment;
import io.github.tehstoneman.betterstorage.utils.WorldUtils;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLockableDoor
extends TileEntity
implements ILockable,
IHasAttachments {
    private final Attachments attachments = new Attachments(this);
    public LockAttachment lockAttachment;
    public EnumFacing orientation = EnumFacing.NORTH;
    private boolean powered = false;
    private boolean swing = false;
    public boolean isOpen = false;
    public boolean isMirrored = false;

    public TileEntityLockableDoor() {
        this.lockAttachment = this.attachments.add(LockAttachment.class);
        this.lockAttachment.setScale(0.5f, 1.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return WorldUtils.getAABB(this, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    private void updateLockPosition() {
        switch (this.orientation) {
            case WEST: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(12.5, -1.5, 1.5, 5.0, 6.0, 3.0);
                    break;
                }
                this.lockAttachment.setBox(1.5, -1.5, 12.5, 3.0, 6.0, 5.0);
                break;
            }
            case EAST: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(3.5, -1.5, 14.5, 5.0, 6.0, 3.0);
                    break;
                }
                this.lockAttachment.setBox(14.5, -1.5, 3.5, 3.0, 6.0, 5.0);
                break;
            }
            case SOUTH: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(1.5, -1.5, 3.5, 3.0, 6.0, 5.0);
                    break;
                }
                this.lockAttachment.setBox(12.5, -1.5, 14.5, 5.0, 6.0, 3.0);
                break;
            }
            default: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(14.5, -1.5, 12.5, 3.0, 6.0, 5.0);
                    break;
                }
                this.lockAttachment.setBox(3.5, -1.5, 1.5, 5.0, 6.0, 3.0);
            }
        }
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public ItemStack getLock() {
        return this.lockAttachment.getItem();
    }

    @Override
    public boolean isLockValid(ItemStack lock) {
        return lock.func_190926_b() || lock.func_77973_b() instanceof ILock;
    }

    @Override
    public void setLock(ItemStack lock) {
        if (lock.func_190926_b()) {
            this.lockAttachment.setItem(ItemStack.field_190927_a);
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockDoor.field_176521_M, this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177229_b((IProperty)BlockDoor.field_176521_M));
            Block block = blockState.func_177230_c();
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, blockState.func_177229_b((IProperty)BlockDoor.field_176520_a)).func_177226_a((IProperty)BlockDoor.field_176519_b, blockState.func_177229_b((IProperty)BlockDoor.field_176519_b)).func_177226_a((IProperty)BlockDoor.field_176521_M, blockState.func_177229_b((IProperty)BlockDoor.field_176521_M)).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER));
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, blockState.func_177229_b((IProperty)BlockDoor.field_176520_a)).func_177226_a((IProperty)BlockDoor.field_176519_b, blockState.func_177229_b((IProperty)BlockDoor.field_176519_b)).func_177226_a((IProperty)BlockDoor.field_176521_M, blockState.func_177229_b((IProperty)BlockDoor.field_176521_M)).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER));
        } else {
            this.setLockWithUpdate(lock);
        }
    }

    public void setLockWithUpdate(ItemStack lock) {
        this.lockAttachment.setItem(lock);
        this.updateLockPosition();
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
        this.func_70296_d();
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return false;
    }

    @Override
    public void useUnlocked(EntityPlayer player) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        state = state.func_177231_a((IProperty)BlockDoor.field_176519_b);
        this.field_145850_b.func_180501_a(this.field_174879_c, state, 10);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b) != false ? SoundEvents.field_187611_cI : SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.isOpen = !this.isOpen;
        this.updateLockPosition();
    }

    @Override
    public void applyTrigger() {
        this.setPowered(true);
    }

    public boolean onBlockActivated(World world, BlockPos pos, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            Logger.getLogger("betterstorage").info("Block Acticated");
            if (this.canUse(player)) {
                this.useUnlocked(player);
            } else if (!this.getLock().func_190926_b()) {
                ((ILock)this.getLock().func_77973_b()).applyEffects(this.getLock(), this, player, EnumLockInteraction.OPEN);
            }
        }
        return false;
    }

    public boolean func_145842_c(int eventID, int par) {
        this.swing = true;
        this.isOpen = par == 1;
        this.updateLockPosition();
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        return true;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        if (this.powered == powered) {
            return;
        }
        this.powered = powered;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return compound;
    }

    public void handleUpdateTag(NBTTagCompound compound) {
        this.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("isOpen", this.isOpen);
        compound.func_74757_a("isMirrored", this.isMirrored);
        compound.func_74774_a("orientation", (byte)this.orientation.ordinal());
        if (!this.lockAttachment.getItem().func_190926_b()) {
            compound.func_74782_a("lock", (NBTBase)this.lockAttachment.getItem().func_77955_b(new NBTTagCompound()));
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isOpen = compound.func_74767_n("isOpen");
        this.isMirrored = compound.func_74767_n("isMirrored");
        this.orientation = EnumFacing.func_82600_a((int)compound.func_74771_c("orientation"));
        if (compound.func_74764_b("lock")) {
            this.lockAttachment.setItem(new ItemStack(compound.func_74775_l("lock")));
        }
        this.updateLockPosition();
    }
}

