/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityConnectable;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLockable;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedLocker;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLocker
extends TileEntityLockable {
    private static final EnumFacing[] neighbors = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
    public boolean mirror = false;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    @Override
    public boolean canHaveLock() {
        return false;
    }

    @Override
    public void setAttachmentPosition() {
    }

    @Override
    public EnumFacing[] getPossibleNeighbors() {
        return neighbors;
    }

    @Override
    protected String getConnectableName() {
        return "container.betterstorage.locker";
    }

    @Override
    public boolean canConnect(TileEntityConnectable connectable) {
        if (!(connectable instanceof TileEntityLocker)) {
            return false;
        }
        TileEntityLocker locker = (TileEntityLocker)connectable;
        return super.canConnect(connectable) && this.mirror == locker.mirror;
    }

    @Override
    public boolean onBlockActivated(BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.getOrientation() != side) {
            return false;
        }
        return super.onBlockActivated(pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.brokenInCreative) {
            ItemStack stack = this instanceof TileEntityReinforcedLocker ? new ItemStack((Block)BetterStorageBlocks.REINFORCED_LOCKER, 1, this.material.getMetadata()) : new ItemStack((Block)BetterStorageBlocks.LOCKER);
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), stack);
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        compound.func_74757_a("mirror", this.mirror);
        return compound;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound compound = packet.func_148857_g();
        this.mirror = compound.func_74767_n("mirror");
        this.setAttachmentPosition();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.mirror = compound.func_74767_n("mirror");
        this.setAttachmentPosition();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("mirror", this.mirror);
        return compound;
    }
}

