/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLockable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityReinforcedChest
extends TileEntityLockable {
    private static EnumFacing[] neighbors = new EnumFacing[]{EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH};

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    @Override
    public void setAttachmentPosition() {
        double x = !this.isConnected() ? 8.0 : (this.getOrientation() == EnumFacing.WEST || this.getOrientation() == EnumFacing.SOUTH ? 0.0 : 16.0);
        this.lockAttachment.setBox(x, 6.5, 0.5, 7.0, 7.0, 1.0);
    }

    @Override
    public int getColumns() {
        return BetterStorage.config.reinforcedColumns;
    }

    @Override
    protected String getConnectableName() {
        return "container.betterstorage.reinforced_chest";
    }

    @Override
    public EnumFacing[] getPossibleNeighbors() {
        EnumFacing facing = this.getOrientation();
        return new EnumFacing[]{facing.func_176746_e(), facing.func_176735_f()};
    }

    public void setCustomInventoryName(String displayName) {
    }

    @Override
    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.brokenInCreative) {
            ItemStack stack = new ItemStack((Block)BetterStorageBlocks.REINFORCED_CHEST, 1, this.material.getMetadata());
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), stack);
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        return compound;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound compound) {
        super.handleUpdateTag(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }
}

