/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.world;

import io.github.tehstoneman.betterstorage.common.inventory.CrateStackHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CrateStackCollection
extends WorldSavedData {
    private static final String filename = "betterstorage_cratepile";
    private final Map<UUID, CrateStackHandler> pileDataMap = new HashMap<UUID, CrateStackHandler>();

    public CrateStackCollection() {
        super(filename);
    }

    public CrateStackCollection(String filename) {
        super(filename);
    }

    public static CrateStackCollection getCollection(World worldIn) {
        CrateStackCollection collection = (CrateStackCollection)worldIn.func_72943_a(CrateStackCollection.class, filename);
        if (collection == null) {
            collection = new CrateStackCollection();
            worldIn.func_72823_a(filename, (WorldSavedData)collection);
        }
        return collection;
    }

    public CrateStackHandler getCratePile(UUID pileID) {
        if (pileID != null && this.pileDataMap.containsKey(pileID)) {
            return this.pileDataMap.get(pileID);
        }
        return this.createCratePile();
    }

    @SideOnly(value=Side.CLIENT)
    public CrateStackHandler getOrCreateCratePile(UUID pileID) {
        if (!this.pileDataMap.containsKey(pileID)) {
            CrateStackHandler cratePile = new CrateStackHandler(18);
            this.pileDataMap.put(pileID, cratePile);
            cratePile.setPileID(pileID);
        }
        return this.pileDataMap.get(pileID);
    }

    public CrateStackHandler createCratePile() {
        UUID pileID = UUID.randomUUID();
        while (this.pileDataMap.containsKey(pileID)) {
            pileID = UUID.randomUUID();
        }
        return this.addCrateToPile(pileID);
    }

    public CrateStackHandler addCrateToPile(UUID pileID) {
        CrateStackHandler cratePile = new CrateStackHandler(18);
        this.pileDataMap.put(pileID, cratePile);
        cratePile.setPileID(pileID);
        this.func_76185_a();
        return cratePile;
    }

    public void removeCratePile(UUID pileID) {
        this.pileDataMap.remove(pileID);
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound compound) {
        if (!compound.func_82582_d()) {
            for (String key : compound.func_150296_c()) {
                CrateStackHandler crateStackHandler = new CrateStackHandler(0);
                crateStackHandler.deserializeNBT(compound.func_74775_l(key));
                this.pileDataMap.put(UUID.fromString(key), crateStackHandler);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        if (!this.pileDataMap.isEmpty()) {
            for (Map.Entry<UUID, CrateStackHandler> entry : this.pileDataMap.entrySet()) {
                compound.func_74782_a(entry.getKey().toString(), (NBTBase)entry.getValue().serializeNBT());
            }
        }
        return compound;
    }
}

