/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class BetterStorageConfig {
    private final Configuration config;
    public static final String CATEGORY_BLOCKS = "blocks";
    public static final String CATEGORY_ITEMS = "items";
    public static final String CATEGORY_ENCHANTMENTS = "enchantments";
    public boolean crateEnabled;
    public boolean reinforcedChestEnabled;
    public boolean lockerEnabled;
    public boolean reinforcedLockerEnabled;
    public boolean lockableDoorEnabled;
    public boolean flintBlockEnabled;
    public boolean cardboardBoxEnabled;
    public boolean keyEnabled;
    public boolean masterKeyEnabled;
    public boolean keyringEnabled;
    public boolean lockEnabled;
    public boolean cardboardSheetEnabled;
    public boolean slimeBucketEnabled;
    public boolean cardboardHelmetEnabled;
    public boolean cardboardChestplateEnabled;
    public boolean cardboardLeggingsEnabled;
    public boolean cardboardBootsEnabled;
    public boolean cardboardSwordEnabled;
    public boolean cardboardPickaxeEnabled;
    public boolean cardboardShovelEnabled;
    public boolean cardboardAxeEnabled;
    public boolean cardboardHoeEnabled;
    public boolean enchUnlockingEnabled;
    public boolean enchLockpickingEnabled;
    public boolean enchMorphingEnabled;
    public boolean enchPersistanceEnabled;
    public boolean enchSecurityEnabled;
    public boolean enchShockEnabled;
    public boolean enchTriggerEnabled;
    public int reinforcedColumns;
    public boolean enableCrateInventoryInterface;
    public int cardboardBoxRows;
    public int cardboardBoxUses;
    public boolean cardboardBoxShowContents;
    public boolean lockBreakable;
    public boolean enableHelpTooltips;
    public boolean enableWarningMessages;

    public BetterStorageConfig(File file) {
        this.config = new Configuration(file);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void syncFromFile() {
        this.syncConfig(true, true);
    }

    public void syncFromGUI() {
        this.syncConfig(false, true);
    }

    public void syncFromFields() {
        this.syncConfig(false, false);
    }

    public void syncConfig(boolean loadConfigFromFile, boolean readFieldsFromConfig) {
        if (loadConfigFromFile) {
            this.config.load();
        }
        Property propCrateEnabled = this.config.get(CATEGORY_BLOCKS, "crateEnabled", true).setLanguageKey("tile.betterstorage.crate.name").setRequiresMcRestart(true);
        Property propReinforcedChestEnabled = this.config.get(CATEGORY_BLOCKS, "reinforcedChestEnabled", true).setLanguageKey("tile.betterstorage.reinforced_chest.name").setRequiresMcRestart(true);
        Property propLockerEnabled = this.config.get(CATEGORY_BLOCKS, "lockerEnabled", true).setLanguageKey("tile.betterstorage.locker.name").setRequiresMcRestart(true);
        Property propReinforcedLockerEnabled = this.config.get(CATEGORY_BLOCKS, "reinforcedLockerEnabled", true).setLanguageKey("tile.betterstorage.reinforced_locker.name").setRequiresMcRestart(true);
        Property propLockableDoorEnabled = this.config.get(CATEGORY_BLOCKS, "lockableDoorEnabled", true).setLanguageKey("tile.betterstorage.lockable_door.name").setRequiresMcRestart(true);
        Property propFlintBlockEnabled = this.config.get(CATEGORY_BLOCKS, "flintBlockEnabled", true).setLanguageKey("tile.betterstorage.flint_block.name").setRequiresMcRestart(true);
        Property propCardboardBoxEnabled = this.config.get(CATEGORY_BLOCKS, "cardboardBoxEnabled", true).setLanguageKey("tile.betterstorage.cardboard_box.name").setRequiresMcRestart(true);
        Property propKeyEnabled = this.config.get(CATEGORY_ITEMS, "keyEnabled", true).setLanguageKey("item.betterstorage.key.name").setRequiresMcRestart(true);
        Property propMasterKeyEnabled = this.config.get(CATEGORY_ITEMS, "masterKeyEnabled", true).setLanguageKey("item.betterstorage.master_key.name").setRequiresMcRestart(true);
        Property propKeyringEnabled = this.config.get(CATEGORY_ITEMS, "keyringEnabled", true).setLanguageKey("item.betterstorage.keyring.name").setRequiresMcRestart(true);
        Property propLockEnabled = this.config.get(CATEGORY_ITEMS, "lockEnabled", true).setLanguageKey("item.betterstorage.lock.name").setRequiresMcRestart(true);
        Property propCardboardSheetEnabled = this.config.get(CATEGORY_ITEMS, "cardboardSheetEnabled", true).setLanguageKey("item.betterstorage.cardboard_sheet.name").setRequiresMcRestart(true);
        Property propCardboardHelmetEnabled = this.config.get(CATEGORY_ITEMS, "cardboardHelmetEnabled", true).setLanguageKey("item.betterstorage.cardboard_helmet.name").setRequiresMcRestart(true);
        Property propCardboardChestplateEnabled = this.config.get(CATEGORY_ITEMS, "cardboardChestplateEnabled", true).setLanguageKey("item.betterstorage.cardboard_chestplate.name").setRequiresMcRestart(true);
        Property propCardboardLeggingsEnabled = this.config.get(CATEGORY_ITEMS, "cardboardLeggingsEnabled", true).setLanguageKey("item.betterstorage.cardboard_leggings.name").setRequiresMcRestart(true);
        Property propCardboardBootsEnabled = this.config.get(CATEGORY_ITEMS, "cardboardBootsEnabled", true).setLanguageKey("item.betterstorage.cardboard_boots.name").setRequiresMcRestart(true);
        Property propCardboardSwordEnabled = this.config.get(CATEGORY_ITEMS, "cardboardSwordEnabled", true).setLanguageKey("item.betterstorage.cardboard_sword.name").setRequiresMcRestart(true);
        Property propCardboardPickaxeEnabled = this.config.get(CATEGORY_ITEMS, "cardboardPickaxeEnabled", true).setLanguageKey("item.betterstorage.cardboard_pickaxe.name").setRequiresMcRestart(true);
        Property propCardboardShovelEnabled = this.config.get(CATEGORY_ITEMS, "cardboardShovelEnabled", true).setLanguageKey("item.betterstorage.cardboard_shovel.name").setRequiresMcRestart(true);
        Property propCardboardAxeEnabled = this.config.get(CATEGORY_ITEMS, "cardboardAxeEnabled", true).setLanguageKey("item.betterstorage.cardboard_axe.name").setRequiresMcRestart(true);
        Property propCardboardHoeEnabled = this.config.get(CATEGORY_ITEMS, "cardboardHoeEnabled", true).setLanguageKey("item.betterstorage.cardboard_hoe.name").setRequiresMcRestart(true);
        Property propSlimeBucketEnabled = this.config.get(CATEGORY_ITEMS, "slimeBucketEnabled", true).setLanguageKey("item.betterstorage.bucket.slime.name").setRequiresMcRestart(true);
        Property propEnchUnlockingEnabled = this.config.get(CATEGORY_ENCHANTMENTS, "enchUnlockingEnabled", true).setLanguageKey("enchantment.betterstorage.key.unlocking").setRequiresMcRestart(true);
        Property propEnchLockpickingEnabled = this.config.get(CATEGORY_ENCHANTMENTS, "enchLockpickingEnabled", true).setLanguageKey("enchantment.betterstorage.key.lockpicking").setRequiresMcRestart(true);
        Property propEnchMorphingEnabled = this.config.get(CATEGORY_ENCHANTMENTS, "enchMorphingEnabled", true).setLanguageKey("enchantment.betterstorage.key.morphing").setRequiresMcRestart(true);
        Property propEnchPersistanceEnabled = this.config.get(CATEGORY_ENCHANTMENTS, "enchPersistanceEnabled", true).setLanguageKey("enchantment.betterstorage.lock.persistance").setRequiresMcRestart(true);
        Property propEnchSecurityEnabled = this.config.get(CATEGORY_ENCHANTMENTS, "enchSecurityEnabled", true).setLanguageKey("enchantment.betterstorage.lock.security").setRequiresMcRestart(true);
        Property propEnchShockEnabled = this.config.get(CATEGORY_ENCHANTMENTS, "enchShockEnabled", true).setLanguageKey("enchantment.betterstorage.lock.shock").setRequiresMcRestart(true);
        Property propEnchTriggerEnabled = this.config.get(CATEGORY_ENCHANTMENTS, "enchTriggerEnabled", true).setLanguageKey("enchantment.betterstorage.lock.trigger").setRequiresMcRestart(true);
        Property propReinforcedColumns = this.config.get("general", "reinforcedColumns", "13", "Number of columns in reinforced chests and lockers. Valid values are 9, 11 and 13.", new String[]{"9", "11", "13"}).setLanguageKey("config.betterstorage.general.reinforcedColumns");
        Property propCrateInventoryInterface = this.config.get("general", "enableCrateInventoryInterface", true, "If enabled, exposes a special block view of crates, so items can be moved in and out by automated systems.").setLanguageKey("config.betterstorage.general.enableCrateInventoryInterface");
        Property propCardboardBoxRows = this.config.get("general", "cardboardBoxRows", 1, "Number of rows in cardboard boxes. Valid values are 1 to 3.", 1, 3).setLanguageKey("config.betterstorage.general.cardboardBoxRows");
        Property propCardboardBoxUses = this.config.get("general", "cardboardBoxUses", 4, "Number of times cardboard boxes can be picked up with items before they break. Use 0 for infinite uses.", 0, Integer.MAX_VALUE).setLanguageKey("config.betterstorage.general.cardboardBoxUses");
        Property propCardboardBoxShowContents = this.config.get("general", "cardboardBoxShowContents", true, "If disabled, doesn't show cardboard box contents in their tooltips.").setLanguageKey("config.betterstorage.general.cardboardBoxShowContents");
        Property propLockBreakable = this.config.get("general", "lockBreakable", true, "If disabled, turns off the ability to break locks off of locked containers using tools.").setLanguageKey("config.betterstorage.general.lockBreakable");
        Property propEnableHelpTooltips = this.config.get("general", "enableHelpTooltips", true, "If enabled, shows tooltips on some items to help players who're new to the mod.").setLanguageKey("config.betterstorage.general.enableHelpTooltips");
        Property propEnableWarningMessages = this.config.get("general", "enableWarningMessages", false, "If disabled, prevents certain warning messages from being logged to the console.").setLanguageKey("config.betterstorage.general.enableWarningMessages");
        if (readFieldsFromConfig) {
            this.enchUnlockingEnabled = propEnchUnlockingEnabled.getBoolean();
            this.enchLockpickingEnabled = propEnchLockpickingEnabled.getBoolean();
            this.enchMorphingEnabled = propEnchMorphingEnabled.getBoolean();
            this.enchPersistanceEnabled = propEnchPersistanceEnabled.getBoolean();
            this.enchSecurityEnabled = propEnchSecurityEnabled.getBoolean();
            this.enchShockEnabled = propEnchShockEnabled.getBoolean();
            this.enchTriggerEnabled = propEnchTriggerEnabled.getBoolean();
            this.crateEnabled = propCrateEnabled.getBoolean();
            this.reinforcedChestEnabled = propReinforcedChestEnabled.getBoolean();
            this.lockerEnabled = propLockerEnabled.getBoolean();
            this.reinforcedLockerEnabled = propReinforcedLockerEnabled.getBoolean();
            this.lockableDoorEnabled = propLockableDoorEnabled.getBoolean();
            this.flintBlockEnabled = propFlintBlockEnabled.getBoolean();
            this.cardboardBoxEnabled = propCardboardBoxEnabled.getBoolean();
            this.cardboardHelmetEnabled = propCardboardHelmetEnabled.getBoolean();
            this.cardboardChestplateEnabled = propCardboardChestplateEnabled.getBoolean();
            this.cardboardLeggingsEnabled = propCardboardLeggingsEnabled.getBoolean();
            this.cardboardBootsEnabled = propCardboardBootsEnabled.getBoolean();
            this.cardboardSwordEnabled = propCardboardSwordEnabled.getBoolean();
            this.cardboardPickaxeEnabled = propCardboardPickaxeEnabled.getBoolean();
            this.cardboardShovelEnabled = propCardboardShovelEnabled.getBoolean();
            this.cardboardAxeEnabled = propCardboardAxeEnabled.getBoolean();
            this.cardboardHoeEnabled = propCardboardHoeEnabled.getBoolean();
            this.slimeBucketEnabled = propSlimeBucketEnabled.getBoolean();
            this.keyEnabled = propKeyEnabled.getBoolean();
            this.masterKeyEnabled = propMasterKeyEnabled.getBoolean();
            this.keyringEnabled = propKeyringEnabled.getBoolean();
            this.lockEnabled = propLockEnabled.getBoolean();
            this.cardboardSheetEnabled = propCardboardSheetEnabled.getBoolean();
            this.reinforcedColumns = propReinforcedColumns.getInt();
            this.enableCrateInventoryInterface = propCrateInventoryInterface.getBoolean();
            this.cardboardBoxRows = propCardboardBoxRows.getInt();
            this.cardboardBoxUses = propCardboardBoxUses.getInt();
            this.cardboardBoxShowContents = propCardboardBoxShowContents.getBoolean();
            this.lockBreakable = propLockBreakable.getBoolean();
            this.enableHelpTooltips = propEnableHelpTooltips.getBoolean();
            this.enableWarningMessages = propEnableWarningMessages.getBoolean();
        }
        propEnchUnlockingEnabled.set(this.enchUnlockingEnabled);
        propEnchLockpickingEnabled.set(this.enchLockpickingEnabled);
        propEnchMorphingEnabled.set(this.enchMorphingEnabled);
        propEnchPersistanceEnabled.set(this.enchPersistanceEnabled);
        propEnchSecurityEnabled.set(this.enchSecurityEnabled);
        propEnchShockEnabled.set(this.enchShockEnabled);
        propEnchTriggerEnabled.set(this.enchTriggerEnabled);
        propCrateEnabled.set(this.crateEnabled);
        propReinforcedChestEnabled.set(this.reinforcedChestEnabled);
        propLockerEnabled.set(this.lockerEnabled);
        propReinforcedLockerEnabled.set(this.reinforcedLockerEnabled);
        propLockableDoorEnabled.set(this.lockableDoorEnabled);
        propFlintBlockEnabled.set(this.flintBlockEnabled);
        propCardboardBoxEnabled.set(this.cardboardBoxEnabled);
        propKeyEnabled.set(this.keyEnabled);
        propMasterKeyEnabled.set(this.masterKeyEnabled);
        propKeyringEnabled.set(this.keyringEnabled);
        propLockEnabled.set(this.lockEnabled);
        propCardboardSheetEnabled.set(this.cardboardSheetEnabled);
        propSlimeBucketEnabled.set(this.slimeBucketEnabled);
        propReinforcedColumns.set(this.reinforcedColumns);
        propReinforcedChestEnabled.set(this.enableCrateInventoryInterface);
        propCardboardBoxRows.set(this.cardboardBoxRows);
        propCardboardBoxUses.set(this.cardboardBoxUses);
        propCardboardBoxShowContents.set(this.cardboardBoxShowContents);
        propLockBreakable.set(this.lockBreakable);
        propEnableHelpTooltips.set(this.enableHelpTooltips);
        propEnableWarningMessages.set(this.enableWarningMessages);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }
}

