/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.event;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.api.ICardboardItem;
import io.github.tehstoneman.betterstorage.api.IDyeableItem;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.common.item.ItemBlockCrate;
import io.github.tehstoneman.betterstorage.common.item.ItemBlockLocker;
import io.github.tehstoneman.betterstorage.common.item.ItemBlockReinforcedChest;
import io.github.tehstoneman.betterstorage.common.item.ItemBlockReinforcedLocker;
import io.github.tehstoneman.betterstorage.common.item.ItemBucketSlime;
import io.github.tehstoneman.betterstorage.common.item.cardboard.ItemBlockCardboardBox;
import io.github.tehstoneman.betterstorage.common.item.cardboard.ItemCardboardSheet;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityCardboardBox;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityCrate;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLockableDoor;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLocker;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedChest;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedLocker;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BetterStorageEventHandler {
    private boolean preventSlimeBucketUse;

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        if (BetterStorage.config.crateEnabled) {
            BetterStorageBlocks.CRATE.func_149663_c("betterstorage." + BetterStorageBlocks.CRATE.getBlockName());
            BetterStorageBlocks.CRATE.setRegistryName(BetterStorageBlocks.CRATE.getBlockName());
            registry.register((IForgeRegistryEntry)BetterStorageBlocks.CRATE);
            GameRegistry.registerTileEntity(TileEntityCrate.class, (String)"container.betterstorage.crate");
        }
        if (BetterStorage.config.reinforcedChestEnabled) {
            BetterStorageBlocks.REINFORCED_CHEST.func_149663_c("betterstorage." + BetterStorageBlocks.REINFORCED_CHEST.getBlockName());
            BetterStorageBlocks.REINFORCED_CHEST.setRegistryName(BetterStorageBlocks.REINFORCED_CHEST.getBlockName());
            registry.register((IForgeRegistryEntry)BetterStorageBlocks.REINFORCED_CHEST);
            GameRegistry.registerTileEntity(TileEntityReinforcedChest.class, (String)"container.betterstorage.reinforced_chest");
        }
        if (BetterStorage.config.lockerEnabled) {
            BetterStorageBlocks.LOCKER.func_149663_c("betterstorage." + BetterStorageBlocks.LOCKER.getBlockName());
            BetterStorageBlocks.LOCKER.setRegistryName(BetterStorageBlocks.LOCKER.getBlockName());
            registry.register((IForgeRegistryEntry)BetterStorageBlocks.LOCKER);
            GameRegistry.registerTileEntity(TileEntityLocker.class, (String)"container.betterstorage.locker");
            if (BetterStorage.config.reinforcedLockerEnabled) {
                BetterStorageBlocks.REINFORCED_LOCKER.func_149663_c("betterstorage." + BetterStorageBlocks.REINFORCED_LOCKER.getBlockName());
                BetterStorageBlocks.REINFORCED_LOCKER.setRegistryName(BetterStorageBlocks.REINFORCED_LOCKER.getBlockName());
                registry.register((IForgeRegistryEntry)BetterStorageBlocks.REINFORCED_LOCKER);
                GameRegistry.registerTileEntity(TileEntityReinforcedLocker.class, (String)"container.betterstorage.reinforced_locker");
            }
        }
        if (BetterStorage.config.flintBlockEnabled) {
            BetterStorageBlocks.BLOCK_FLINT.func_149663_c("betterstorage." + BetterStorageBlocks.BLOCK_FLINT.getBlockName());
            BetterStorageBlocks.BLOCK_FLINT.setRegistryName(BetterStorageBlocks.BLOCK_FLINT.getBlockName());
            registry.register((IForgeRegistryEntry)BetterStorageBlocks.BLOCK_FLINT);
        }
        if (BetterStorage.config.keyEnabled && BetterStorage.config.lockableDoorEnabled) {
            BetterStorageBlocks.LOCKABLE_DOOR.func_149663_c("betterstorage." + BetterStorageBlocks.LOCKABLE_DOOR.getBlockName());
            BetterStorageBlocks.LOCKABLE_DOOR.setRegistryName(BetterStorageBlocks.LOCKABLE_DOOR.getBlockName());
            registry.register((IForgeRegistryEntry)BetterStorageBlocks.LOCKABLE_DOOR);
            GameRegistry.registerTileEntity(TileEntityLockableDoor.class, (String)"betterstorage.lockableDoor");
        }
        if (BetterStorage.config.cardboardBoxEnabled) {
            BetterStorageBlocks.CARDBOARD_BOX.func_149663_c("betterstorage." + BetterStorageBlocks.CARDBOARD_BOX.getBlockName());
            BetterStorageBlocks.CARDBOARD_BOX.setRegistryName(BetterStorageBlocks.CARDBOARD_BOX.getBlockName());
            registry.register((IForgeRegistryEntry)BetterStorageBlocks.CARDBOARD_BOX);
            GameRegistry.registerTileEntity(TileEntityCardboardBox.class, (String)"container.betterstorage.cardboard_box");
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        if (BetterStorage.config.crateEnabled) {
            registry.register(new ItemBlockCrate(BetterStorageBlocks.CRATE).setRegistryName(BetterStorageBlocks.CRATE.getRegistryName()));
        }
        if (BetterStorage.config.reinforcedChestEnabled) {
            registry.register(new ItemBlockReinforcedChest(BetterStorageBlocks.REINFORCED_CHEST).setRegistryName(BetterStorageBlocks.REINFORCED_CHEST.getRegistryName()));
        }
        if (BetterStorage.config.lockerEnabled) {
            registry.register(new ItemBlockLocker(BetterStorageBlocks.LOCKER).setRegistryName(BetterStorageBlocks.LOCKER.getRegistryName()));
            if (BetterStorage.config.reinforcedLockerEnabled) {
                registry.register(new ItemBlockReinforcedLocker(BetterStorageBlocks.REINFORCED_LOCKER).setRegistryName(BetterStorageBlocks.REINFORCED_LOCKER.getRegistryName()));
            }
        }
        if (BetterStorage.config.flintBlockEnabled) {
            registry.register(new ItemBlock((Block)BetterStorageBlocks.BLOCK_FLINT).setRegistryName(BetterStorageBlocks.BLOCK_FLINT.getRegistryName()));
        }
        if (BetterStorage.config.keyEnabled) {
            BetterStorageItems.KEY.register();
            registry.register((IForgeRegistryEntry)BetterStorageItems.KEY);
            if (BetterStorage.config.masterKeyEnabled) {
                BetterStorageItems.MASTER_KEY.register();
                registry.register((IForgeRegistryEntry)BetterStorageItems.MASTER_KEY);
            }
            if (BetterStorage.config.keyringEnabled) {
                BetterStorageItems.KEYRING.register();
                registry.register((IForgeRegistryEntry)BetterStorageItems.KEYRING);
            }
            if (BetterStorage.config.lockEnabled) {
                BetterStorageItems.LOCK.register();
                registry.register((IForgeRegistryEntry)BetterStorageItems.LOCK);
            }
        }
        if (BetterStorage.config.cardboardSheetEnabled) {
            BetterStorageItems.CARDBOARD_SHEET.register();
            registry.register((IForgeRegistryEntry)BetterStorageItems.CARDBOARD_SHEET);
            OreDictionary.registerOre((String)"sheetCardboard", (Item)BetterStorageItems.CARDBOARD_SHEET);
        }
        if (BetterStorage.config.cardboardBoxEnabled) {
            registry.register(new ItemBlockCardboardBox(BetterStorageBlocks.CARDBOARD_BOX).setRegistryName(BetterStorageBlocks.CARDBOARD_BOX.getRegistryName()));
        }
        if (BetterStorage.config.cardboardSwordEnabled) {
            BetterStorageItems.CARDBOARD_SWORD.register();
            registry.register((IForgeRegistryEntry)BetterStorageItems.CARDBOARD_SWORD);
        }
        if (BetterStorage.config.cardboardShovelEnabled) {
            BetterStorageItems.CARDBOARD_SHOVEL.register();
            registry.register((IForgeRegistryEntry)BetterStorageItems.CARDBOARD_SHOVEL);
        }
        if (BetterStorage.config.cardboardPickaxeEnabled) {
            BetterStorageItems.CARDBOARD_PICKAXE.register();
            registry.register((IForgeRegistryEntry)BetterStorageItems.CARDBOARD_PICKAXE);
        }
        if (BetterStorage.config.cardboardAxeEnabled) {
            BetterStorageItems.CARDBOARD_AXE.register();
            registry.register((IForgeRegistryEntry)BetterStorageItems.CARDBOARD_AXE);
        }
        if (BetterStorage.config.cardboardHoeEnabled) {
            BetterStorageItems.CARDBOARD_HOE.register();
            registry.register((IForgeRegistryEntry)BetterStorageItems.CARDBOARD_HOE);
        }
        if (BetterStorage.config.cardboardHelmetEnabled) {
            BetterStorageItems.CARDBOARD_HELMET.register("cardboard_helmet");
            registry.register((IForgeRegistryEntry)BetterStorageItems.CARDBOARD_HELMET);
        }
        if (BetterStorage.config.cardboardChestplateEnabled) {
            BetterStorageItems.CARDBOARD_CHESTPLATE.register("cardboard_chestplate");
            registry.register((IForgeRegistryEntry)BetterStorageItems.CARDBOARD_CHESTPLATE);
        }
        if (BetterStorage.config.cardboardLeggingsEnabled) {
            BetterStorageItems.CARDBOARD_LEGGINGS.register("cardboard_leggings");
            registry.register((IForgeRegistryEntry)BetterStorageItems.CARDBOARD_LEGGINGS);
        }
        if (BetterStorage.config.cardboardBootsEnabled) {
            BetterStorageItems.CARDBOARD_BOOTS.register("cardboard_boots");
            registry.register((IForgeRegistryEntry)BetterStorageItems.CARDBOARD_BOOTS);
        }
        if (BetterStorage.config.slimeBucketEnabled) {
            BetterStorageItems.SLIME_BUCKET.register();
            registry.register((IForgeRegistryEntry)BetterStorageItems.SLIME_BUCKET);
        }
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        IForgeRegistry registry = event.getRegistry();
        if (BetterStorage.config.keyEnabled) {
            if (BetterStorage.config.enchUnlockingEnabled) {
                EnchantmentBetterStorage.unlocking.setRegistryName("unlocking");
                registry.register((IForgeRegistryEntry)EnchantmentBetterStorage.unlocking);
            }
            if (BetterStorage.config.enchLockpickingEnabled) {
                EnchantmentBetterStorage.lockpicking.setRegistryName("lockpicking");
                registry.register((IForgeRegistryEntry)EnchantmentBetterStorage.lockpicking);
            }
            if (BetterStorage.config.enchMorphingEnabled) {
                EnchantmentBetterStorage.morphing.setRegistryName("morphing");
                registry.register((IForgeRegistryEntry)EnchantmentBetterStorage.morphing);
            }
            if (BetterStorage.config.enchLockpickingEnabled && BetterStorage.config.enchMorphingEnabled) {
                EnchantmentBetterStorage.lockpicking.setIncompatible(EnchantmentBetterStorage.morphing);
                EnchantmentBetterStorage.morphing.setIncompatible(EnchantmentBetterStorage.lockpicking);
            }
        }
        if (BetterStorage.config.lockEnabled) {
            if (BetterStorage.config.enchPersistanceEnabled) {
                EnchantmentBetterStorage.persistance.setRegistryName("persistance");
                registry.register((IForgeRegistryEntry)EnchantmentBetterStorage.persistance);
            }
            if (BetterStorage.config.enchSecurityEnabled) {
                EnchantmentBetterStorage.security.setRegistryName("security");
                registry.register((IForgeRegistryEntry)EnchantmentBetterStorage.security);
            }
            if (BetterStorage.config.enchShockEnabled) {
                EnchantmentBetterStorage.shock.setRegistryName("shock");
                registry.register((IForgeRegistryEntry)EnchantmentBetterStorage.shock);
            }
            if (BetterStorage.config.enchTriggerEnabled) {
                EnchantmentBetterStorage.trigger.setRegistryName("trigger");
                registry.register((IForgeRegistryEntry)EnchantmentBetterStorage.trigger);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChangeEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("betterstorage") && !event.isWorldRunning()) {
            BetterStorage.config.syncFromGUI();
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        NBTTagCompound compound;
        IDyeableItem dyeable;
        int level;
        World world = event.getEntity().field_70170_p;
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack holding = player.func_184614_ca();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        EnumHand hand = event.getHand();
        if (hand == EnumHand.MAIN_HAND && block == Blocks.field_150383_bp && holding.func_77973_b() instanceof IDyeableItem && (level = ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) > 0 && (dyeable = (IDyeableItem)holding.func_77973_b()).canDye(holding) && holding.func_77942_o() && (compound = holding.func_77978_p()).func_74764_b("color")) {
            compound.func_82580_o("color");
            holding.func_77982_d(compound);
            Blocks.field_150383_bp.func_176590_a(world, pos, state, level - 1);
            event.setResult(Event.Result.DENY);
        }
        if (hand == EnumHand.MAIN_HAND && holding.func_77973_b() instanceof ICardboardItem && !ItemCardboardSheet.isEffective(holding)) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            return;
        }
        if (this.preventSlimeBucketUse) {
            event.setCanceled(true);
            this.preventSlimeBucketUse = false;
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        Entity target = event.getTarget();
        ItemStack holding = player.func_184614_ca();
        if (BetterStorage.config.slimeBucketEnabled && target instanceof EntityLiving && holding != null && holding.func_77973_b() == Items.field_151133_ar) {
            ItemBucketSlime.pickUpSlime(player, (EntityLiving)target);
            if (player.func_184614_ca().func_77973_b() instanceof ItemBucketSlime) {
                this.preventSlimeBucketUse = true;
            }
        }
    }
}

