/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.utils;

import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public final class DirectionUtils {
    private DirectionUtils() {
    }

    public static EnumFacing getOrientation(Entity entity) {
        int dir = MathHelper.func_76128_c((double)((double)entity.field_70177_z * 4.0 / 360.0 + 0.5)) & 3;
        switch (dir) {
            case 1: {
                return EnumFacing.WEST;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.SOUTH;
    }

    public static int getRotation(EnumFacing dir) {
        if (dir == EnumFacing.WEST) {
            return 90;
        }
        if (dir == EnumFacing.NORTH) {
            return 180;
        }
        if (dir == EnumFacing.EAST) {
            return 270;
        }
        return 0;
    }

    public static double angleDifference(double angle1, double angle2) {
        return ((angle2 - angle1) % 360.0 + 540.0) % 360.0 - 180.0;
    }

    public static double angleBetween(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
    }

    public static double angleBetween(Entity e1, Entity e2) {
        return DirectionUtils.angleBetween(e1.field_70165_t, e1.field_70161_v, e2.field_70165_t, e2.field_70161_v);
    }
}

