/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class DyeUtils {
    private static final Map<String, EnumDyeColor> dyes = new HashMap<String, EnumDyeColor>();

    private DyeUtils() {
    }

    public static EnumDyeColor getDyeColor(ItemStack stack) {
        int[] oreIds;
        if (stack == null) {
            return null;
        }
        for (int ore : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)ore);
            if (!dyes.containsKey(name)) continue;
            return dyes.get(name);
        }
        return null;
    }

    public static boolean isDye(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        if (oreIDs.length > 0) {
            int dye = OreDictionary.getOreID((String)"dye");
            for (int oreID : oreIDs) {
                if (oreID != dye) continue;
                return true;
            }
        }
        return false;
    }

    public static int getColorFromDyes(int color, Collection<ItemStack> dyes) {
        int number = dyes.size();
        if (number < 1) {
            return -1;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        if (color >= 0) {
            r = color >> 16;
            g = color >> 8 & 0xFF;
            b = color & 0xFF;
            ++number;
        }
        for (ItemStack dye : dyes) {
            color = DyeUtils.getDyeColor(dye).func_193350_e();
            if (color < 0) continue;
            r += color >> 16;
            g += color >> 8 & 0xFF;
            b += color & 0xFF;
        }
        return (r /= number) << 16 | (g /= number) << 8 | (b /= number);
    }

    public static int getColorFromDyes(Collection<ItemStack> dyes) {
        return DyeUtils.getColorFromDyes(-1, dyes);
    }

    private static void addColorFromTable(String name) {
        EnumDyeColor dye = EnumDyeColor.func_176766_a((int)dyes.size());
        int color = dye.func_193350_e();
        dyes.put(name, dye);
    }

    static {
        DyeUtils.addColorFromTable("dyeBlack");
        DyeUtils.addColorFromTable("dyeRed");
        DyeUtils.addColorFromTable("dyeGreen");
        DyeUtils.addColorFromTable("dyeBrown");
        DyeUtils.addColorFromTable("dyeBlue");
        DyeUtils.addColorFromTable("dyePurple");
        DyeUtils.addColorFromTable("dyeCyan");
        DyeUtils.addColorFromTable("dyeLightGray");
        DyeUtils.addColorFromTable("dyeGray");
        DyeUtils.addColorFromTable("dyePink");
        DyeUtils.addColorFromTable("dyeLime");
        DyeUtils.addColorFromTable("dyeYellow");
        DyeUtils.addColorFromTable("dyeLightBlue");
        DyeUtils.addColorFromTable("dyeMagenta");
        DyeUtils.addColorFromTable("dyeOrange");
        DyeUtils.addColorFromTable("dyeWhite");
    }
}

