/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.utils;

import io.github.tehstoneman.betterstorage.utils.DyeUtils;
import io.github.tehstoneman.betterstorage.utils.StackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class InventoryUtils {
    private InventoryUtils() {
    }

    public static boolean hasItem(IInventory inventory, Item item) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack findItem(IInventory inventory, Item item) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            return stack;
        }
        return null;
    }

    public static int findItemSlot(IInventory inventory, Item item) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static int countItems(IInventory inventory, Item item) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            ++count;
        }
        return count;
    }

    public static List<ItemStack> findItems(IInventory inventory, Item item) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            list.add(stack);
        }
        return list;
    }

    public static List<Integer> findItemSlots(IInventory inventory, Item item) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            list.add(i);
        }
        return list;
    }

    public static List<ItemStack> findDyes(IInventory inventory) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!DyeUtils.isDye(stack)) continue;
            list.add(stack);
        }
        return list;
    }

    public static boolean tryAddItemToInventory(ItemStack stack, IInventory inventory, boolean doAdd) {
        ItemStack invStack;
        int i;
        int maxStackSize = Math.min(stack.func_77976_d(), inventory.func_70297_j_());
        if (!doAdd) {
            stack = stack.func_77946_l();
        }
        if (stack.func_77985_e()) {
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                int amount;
                ItemStack testStack;
                invStack = inventory.func_70301_a(i);
                if (StackUtils.matches(stack, invStack) && invStack.func_190916_E() < maxStackSize && inventory.func_94041_b(i, testStack = StackUtils.copyStack(stack, amount = Math.min(invStack.func_190916_E() + stack.func_190916_E(), maxStackSize)))) {
                    stack.func_190920_e(stack.func_190916_E() - testStack.func_190916_E() - invStack.func_190916_E());
                    if (doAdd) {
                        inventory.func_70299_a(i, testStack);
                    }
                }
                if (stack.func_190916_E() > 0) continue;
                return true;
            }
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack testStack;
            invStack = inventory.func_70301_a(i);
            if (invStack == null && inventory.func_94041_b(i, testStack = StackUtils.copyStack(stack, Math.min(stack.func_190916_E(), maxStackSize)))) {
                stack.func_190920_e(stack.func_190916_E() - testStack.func_190916_E());
                if (doAdd) {
                    inventory.func_70299_a(i, testStack);
                }
            }
            if (stack.func_190916_E() > 0) continue;
            return true;
        }
        return false;
    }
}

