/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderUtils {
    private static final ResourceLocation glint = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    private RenderUtils() {
    }

    public static void renderItemIn3d(ItemStack stack) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (textureManager == null) {
            return;
        }
        Item item = stack.func_77973_b();
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.03125f);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public static void setColorFromInt(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, float zLevel, int textureWidth, int textureHeight) {
        float xScale = 1.0f / (float)textureWidth;
        float yScale = 1.0f / (float)textureHeight;
        Tessellator tess = Tessellator.func_178181_a();
        tess.func_78381_a();
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }
}

