/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.utils;

import io.github.tehstoneman.betterstorage.attachment.Attachments;
import io.github.tehstoneman.betterstorage.utils.RandomUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class WorldUtils {
    private WorldUtils() {
    }

    @SideOnly(value=Side.CLIENT)
    public static World getLocalWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static AxisAlignedBB getAABB(TileEntity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double x = entity.func_174877_v().func_177958_n();
        double y = entity.func_174877_v().func_177956_o();
        double z = entity.func_174877_v().func_177952_p();
        return new AxisAlignedBB(x - minX, y - minY, z - minZ, x + maxX + 1.0, y + maxY + 1.0, z + maxZ + 1.0);
    }

    public static AxisAlignedBB getAABB(TileEntity entity, double radius) {
        return WorldUtils.getAABB(entity, radius, radius, radius, radius, radius, radius);
    }

    public static EntityItem spawnItem(World world, double x, double y, double z, ItemStack stack) {
        if (stack == null || stack.func_190916_E() <= 0) {
            return null;
        }
        EntityItem item = new EntityItem(world, x, y, z, stack);
        world.func_72838_d((Entity)item);
        return item;
    }

    public static EntityItem spawnItemWithMotion(World world, double x, double y, double z, ItemStack stack) {
        EntityItem item = WorldUtils.spawnItem(world, x, y, z, stack);
        if (item != null) {
            item.field_70159_w = RandomUtils.getGaussian() * (double)0.05f;
            item.field_70181_x = RandomUtils.getGaussian() * (double)0.05f + (double)0.2f;
            item.field_70179_y = RandomUtils.getGaussian() * (double)0.05f;
        }
        return item;
    }

    public static EntityItem dropStackFromBlock(World world, int x, int y, int z, ItemStack stack) {
        float itemX = (float)x + RandomUtils.getFloat(0.1f, 0.9f);
        float itemY = (float)y + RandomUtils.getFloat(0.1f, 0.9f);
        float itemZ = (float)z + RandomUtils.getFloat(0.1f, 0.9f);
        return WorldUtils.spawnItemWithMotion(world, itemX, itemY, itemZ, stack);
    }

    public static EntityItem dropStackFromBlock(TileEntity te, ItemStack stack) {
        return WorldUtils.dropStackFromBlock(te.func_145831_w(), te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p(), stack);
    }

    public static EntityItem dropStackFromEntity(Entity entity, ItemStack stack, float speed) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (player == null) {
            double y = entity.field_70163_u + (double)entity.func_70047_e() - 0.3;
            EntityItem item = WorldUtils.spawnItem(entity.field_70170_p, entity.field_70165_t, y, entity.field_70161_v, stack);
            if (item == null) {
                return null;
            }
            float f1 = RandomUtils.getFloat(0.5f);
            float f2 = RandomUtils.getFloat((float)Math.PI * 2);
            item.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            item.field_70181_x = 0.2;
            item.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            return item;
        }
        EntityItem item = player.func_71019_a(stack, true);
        if (item != null) {
            item.field_70159_w *= (double)(speed / 4.0f);
            item.field_70179_y *= (double)(speed / 4.0f);
        }
        return item;
    }

    public static <T> boolean is(IBlockAccess world, int x, int y, int z, Class<T> tileClass) {
        return tileClass.isInstance(world.func_175625_s(new BlockPos(x, y, z)));
    }

    public static <T> T get(IBlockAccess world, int x, int y, int z, Class<T> tileClass) {
        TileEntity t = world.func_175625_s(new BlockPos(x, y, z));
        return (T)(tileClass.isInstance(t) ? t : null);
    }

    public static boolean isTileEntityUsableByPlayer(TileEntity entity, EntityPlayer player) {
        return entity.func_145831_w().func_175625_s(entity.func_174877_v()) == entity && player.func_70092_e((double)entity.func_174877_v().func_177958_n() + 0.5, (double)entity.func_174877_v().func_177956_o() + 0.5, (double)entity.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public static void notifyBlocksAround(World world, int x, int y, int z) {
        Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        world.func_175685_c(new BlockPos(x, y, z), block, true);
        world.func_175685_c(new BlockPos(x + 1, y, z), block, true);
        world.func_175685_c(new BlockPos(x - 1, y, z), block, true);
        world.func_175685_c(new BlockPos(x, y + 1, z), block, true);
        world.func_175685_c(new BlockPos(x, y - 1, z), block, true);
        world.func_175685_c(new BlockPos(x, y, z + 1), block, true);
        world.func_175685_c(new BlockPos(x, y, z - 1), block, true);
    }

    public static RayTraceResult rayTrace(EntityPlayer player, float partialTicks) {
        Attachments.playerLocal.set(player);
        double range = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + 1.62 - player.func_70033_W(), player.field_70161_v);
        Vec3d look = player.func_70676_i(1.0f);
        Vec3d end = start.func_72441_c(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);
        RayTraceResult target = player.field_70170_p.func_72933_a(start, end);
        Attachments.playerLocal.remove();
        return target;
    }
}

