/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.tehstoneman.betterstorage.api.ConnectedType;
import io.github.tehstoneman.betterstorage.client.renderer.entity.model.ModelLargeLocker;
import io.github.tehstoneman.betterstorage.client.renderer.entity.model.ModelLocker;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.block.BlockConnectableContainer;
import io.github.tehstoneman.betterstorage.common.block.BlockLocker;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityLocker;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedLocker;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class TileEntityLockerRenderer
extends TileEntityRenderer<TileEntityLocker> {
    private static final ResourceLocation TEXTURE_NORMAL_DOUBLE = new ResourceLocation("betterstorage", "textures/entity/locker/normal_double.png");
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("betterstorage", "textures/entity/locker/normal.png");
    private static final ResourceLocation TEXTURE_REINFORCED_DOUBLE = new ResourceLocation("betterstorage", "textures/entity/locker/reinforced_double.png");
    private static final ResourceLocation TEXTURE_REINFORCED = new ResourceLocation("betterstorage", "textures/entity/locker/reinforced.png");
    private final ModelLocker simpleLocker = new ModelLocker();
    private final ModelLocker largeLocker = new ModelLargeLocker();

    public void render(TileEntityLocker tileEntityLocker, double x, double y, double z, float partialTicks, int destroyStage) {
        DoorHingeSide hingeSide;
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        BlockState iblockstate = tileEntityLocker.func_145830_o() ? tileEntityLocker.func_195044_w() : (BlockState)BetterStorageBlocks.LOCKER.func_176223_P().func_206870_a((IProperty)BlockLocker.FACING, (Comparable)Direction.SOUTH);
        ConnectedType lockertype = iblockstate.func_196959_b(BlockConnectableContainer.TYPE) ? (ConnectedType)((Object)iblockstate.func_177229_b(BlockConnectableContainer.TYPE)) : ConnectedType.SINGLE;
        DoorHingeSide doorHingeSide = hingeSide = iblockstate.func_196959_b((IProperty)BlockStateProperties.field_208142_aq) ? (DoorHingeSide)iblockstate.func_177229_b((IProperty)BlockStateProperties.field_208142_aq) : DoorHingeSide.LEFT;
        if (lockertype != ConnectedType.SLAVE) {
            boolean flag = lockertype != ConnectedType.SINGLE;
            ModelLocker modelchest = this.getLockerModel(tileEntityLocker, destroyStage, flag);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)(flag ? 8.0f : 4.0f), (float)4.0f, (float)1.0f);
                GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.matrixMode((int)5888);
            } else {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.pushMatrix();
            GlStateManager.enableRescaleNormal();
            GlStateManager.translatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            float f = ((Direction)iblockstate.func_177229_b((IProperty)BlockLocker.FACING)).func_185119_l();
            if ((double)Math.abs(f) > 1.0E-5) {
                GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.rotatef((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            this.rotateDoor(tileEntityLocker, partialTicks, modelchest, hingeSide);
            modelchest.renderAll(hingeSide == DoorHingeSide.LEFT);
            if (tileEntityLocker instanceof TileEntityReinforcedLocker) {
                this.renderItem((TileEntityReinforcedLocker)tileEntityLocker, partialTicks, destroyStage, iblockstate);
            }
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.popMatrix();
                GlStateManager.matrixMode((int)5888);
            }
        }
    }

    private ModelLocker getLockerModel(TileEntityLocker tileEntityLocker, int destroyStage, boolean flag) {
        ResourceLocation resourcelocation = destroyStage >= 0 ? field_178460_a[destroyStage] : (tileEntityLocker instanceof TileEntityReinforcedLocker ? (flag ? TEXTURE_REINFORCED_DOUBLE : TEXTURE_REINFORCED) : (flag ? TEXTURE_NORMAL_DOUBLE : TEXTURE_NORMAL));
        this.func_147499_a(resourcelocation);
        return flag ? this.largeLocker : this.simpleLocker;
    }

    private void rotateDoor(TileEntityLocker tileEntityLocker, float partialTicks, ModelLocker modelLocker, DoorHingeSide hingeSide) {
        float f = tileEntityLocker.func_195480_a(partialTicks);
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        switch (hingeSide) {
            default: {
                modelLocker.getDoor((boolean)true).field_78796_g = f * 1.5707964f;
                break;
            }
            case RIGHT: {
                modelLocker.getDoor((boolean)false).field_78796_g = -(f * 1.5707964f);
            }
        }
    }

    private void renderItem(TileEntityReinforcedLocker locker, float partialTicks, int destroyStage, BlockState state) {
        ItemStack itemstack = locker.getLock();
        if (!itemstack.func_190926_b()) {
            ItemEntity ItemEntity2 = new ItemEntity(locker.func_145831_w(), 0.0, 0.0, 0.0, itemstack);
            GlStateManager.pushMatrix();
            GlStateManager.disableLighting();
            float openAngle = locker.func_195480_a(partialTicks);
            openAngle = 1.0f - openAngle;
            openAngle = 1.0f - openAngle * openAngle * openAngle;
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            boolean left = state.func_177229_b((IProperty)DoorBlock.field_176521_M) == DoorHingeSide.LEFT;
            GlStateManager.translated((double)(left ? 0.0 : 1.0), (double)0.0, (double)0.1875);
            GlStateManager.rotated((double)(left ? (double)(openAngle * 90.0f) : (double)(-openAngle * 90.0f)), (double)0.0, (double)1.0, (double)0.0);
            GlStateManager.translated((double)(left ? -0.0 : -1.0), (double)0.0, (double)-0.1875);
            GlStateManager.rotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            GlStateManager.translated((double)(left ? -0.8125 : -0.1875), (double)(locker.isConnected() ? -0.125 : -0.625), (double)0.03125);
            GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
            RenderHelper.func_74519_b();
            itemRenderer.func_181564_a(ItemEntity2.func_92059_d(), ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
        }
    }
}

