/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.tehstoneman.betterstorage.api.ConnectedType;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.block.BlockConnectableContainer;
import io.github.tehstoneman.betterstorage.common.block.BlockReinforcedChest;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedChest;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.model.ChestModel;
import net.minecraft.client.renderer.tileentity.model.LargeChestModel;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class TileEntityReinforcedChestRenderer
extends TileEntityRenderer<TileEntityReinforcedChest> {
    private static final ResourceLocation TEXTURE_NORMAL_DOUBLE = new ResourceLocation("betterstorage", "textures/entity/chest/reinforced_double.png");
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("betterstorage", "textures/entity/chest/reinforced.png");
    private final ChestModel simpleChest = new ChestModel();
    private final ChestModel largeChest = new LargeChestModel();

    public void render(TileEntityReinforcedChest tileEntityChest, double x, double y, double z, float partialTicks, int destroyStage) {
        ConnectedType chesttype;
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        BlockState iblockstate = tileEntityChest.func_145830_o() ? tileEntityChest.func_195044_w() : (BlockState)BetterStorageBlocks.REINFORCED_CHEST.func_176223_P().func_206870_a((IProperty)BlockReinforcedChest.FACING, (Comparable)Direction.SOUTH);
        ConnectedType connectedType = chesttype = iblockstate.func_196959_b(BlockConnectableContainer.TYPE) ? (ConnectedType)((Object)iblockstate.func_177229_b(BlockConnectableContainer.TYPE)) : ConnectedType.SINGLE;
        if (chesttype != ConnectedType.SLAVE) {
            boolean flag = chesttype != ConnectedType.SINGLE;
            ChestModel modelchest = this.getChestModel(tileEntityChest, destroyStage, flag);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)(flag ? 8.0f : 4.0f), (float)4.0f, (float)1.0f);
                GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.matrixMode((int)5888);
            } else {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.pushMatrix();
            GlStateManager.enableRescaleNormal();
            GlStateManager.translatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            float f = ((Direction)iblockstate.func_177229_b((IProperty)BlockReinforcedChest.FACING)).func_185119_l();
            if ((double)Math.abs(f) > 1.0E-5) {
                GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.rotatef((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            this.rotateLid(tileEntityChest, partialTicks, modelchest);
            modelchest.func_78231_a();
            this.renderItem(tileEntityChest, partialTicks, destroyStage, iblockstate);
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.popMatrix();
                GlStateManager.matrixMode((int)5888);
            }
        }
    }

    private ChestModel getChestModel(TileEntityReinforcedChest tileEntityChest, int destroyStage, boolean flag) {
        ResourceLocation resourcelocation = destroyStage >= 0 ? field_178460_a[destroyStage] : (flag ? TEXTURE_NORMAL_DOUBLE : TEXTURE_NORMAL);
        this.func_147499_a(resourcelocation);
        return flag ? this.largeChest : this.simpleChest;
    }

    private void rotateLid(TileEntityReinforcedChest tileEntityChest, float partialTicks, ChestModel modelchest) {
        float f = tileEntityChest.func_195480_a(partialTicks);
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        modelchest.func_205058_b().field_78795_f = -(f * 1.5707964f);
    }

    private void renderItem(TileEntityReinforcedChest chest, float partialTicks, int destroyStage, BlockState state) {
        ItemStack itemstack = chest.getLock();
        if (!itemstack.func_190926_b()) {
            ItemEntity entityitem = new ItemEntity(chest.func_145831_w(), 0.0, 0.0, 0.0, itemstack);
            GlStateManager.pushMatrix();
            GlStateManager.disableLighting();
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translated((double)(chest.isConnected() ? -1.0 : -0.5), (double)-0.5625, (double)0.03125);
            GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
            RenderHelper.func_74519_b();
            itemRenderer.func_181564_a(entityitem.func_92059_d(), ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
        }
    }
}

