/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.client.renderer.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import io.github.tehstoneman.betterstorage.common.block.BlockTank;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityTank;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityTankRenderer
extends TileEntityRenderer<TileEntityTank> {
    private static AtlasTexture textureAtlas;

    public void render(TileEntityTank tileEntity, double x, double y, double z, float partialTicks, int destroyStage) {
        int capacity = tileEntity.getCapacity();
        FluidStack fluidStack = tileEntity.getFluid();
        Fluid fluid = fluidStack.getFluid();
        if (!fluidStack.isEmpty()) {
            GlStateManager.pushMatrix();
            RenderHelper.func_74518_a();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.enableBlend();
            if (Minecraft.func_71379_u()) {
                GlStateManager.shadeModel((int)7425);
            } else {
                GlStateManager.shadeModel((int)7424);
            }
            if (textureAtlas == null) {
                textureAtlas = Minecraft.func_71410_x().func_147117_R();
            }
            this.func_147499_a(AtlasTexture.field_110575_b);
            ResourceLocation fuildStillTexture = fluid.getAttributes().getStillTexture();
            TextureAtlasSprite fluidStillSprite = textureAtlas.func_110572_b(fuildStillTexture.toString());
            double posY = 0.0625 + 0.875 * (double)((float)fluidStack.getAmount() / (float)capacity);
            int color = fluid.getAttributes().getColor();
            float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            BlockPos pos = tileEntity.func_174877_v();
            BlockState blockState = tileEntity.func_195044_w();
            int packedLightMap = blockState.func_215684_a((IEnviromentBlockReader)this.func_178459_a(), pos);
            int skyLight = packedLightMap >> 16 & 0xFFFF;
            int blockLight = packedLightMap & 0xFFFF;
            double height = 0.875 + ((Boolean)blockState.func_177229_b((IProperty)BlockTank.UP) != false ? 0.0625 : 0.0) + ((Boolean)blockState.func_177229_b((IProperty)BlockTank.DOWN) != false ? 0.0625 : 0.0);
            double x1 = 0.125;
            double y1 = (Boolean)blockState.func_177229_b((IProperty)BlockTank.DOWN) != false ? 0.0 : 0.0625;
            double z1 = 0.125;
            double x2 = 0.875;
            double y2 = y1 + height * (double)((float)fluidStack.getAmount() / (float)capacity);
            double z2 = 0.875;
            if (fluid.getAttributes().isLighterThanAir()) {
                y2 = (Boolean)blockState.func_177229_b((IProperty)BlockTank.UP) != false ? 1.0 : 0.9375;
                y1 = y2 - height * (double)((float)fluidStack.getAmount() / (float)capacity);
            }
            double u1 = fluidStillSprite.func_94214_a(2.0);
            double v1 = fluidStillSprite.func_94207_b(2.0);
            double u2 = fluidStillSprite.func_94214_a(14.0);
            double v2 = fluidStillSprite.func_94207_b(14.0);
            double u3 = fluidStillSprite.func_94214_a(2.0);
            double v3 = fluidStillSprite.func_94207_b(y1 * 16.0);
            double u4 = fluidStillSprite.func_94214_a(14.0);
            double v4 = fluidStillSprite.func_94207_b(y2 * 16.0);
            Tessellator tesselator = Tessellator.func_178181_a();
            BufferBuilder buffer = tesselator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            buffer.func_178969_c(x, y, z);
            if (y2 < 1.0 || tileEntity.getFluidAmountAbove() == 0) {
                buffer.func_181662_b(0.125, y2, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(skyLight, blockLight).func_181675_d();
                buffer.func_181662_b(0.125, y2, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(skyLight, blockLight).func_181675_d();
                buffer.func_181662_b(0.875, y2, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(skyLight, blockLight).func_181675_d();
                buffer.func_181662_b(0.875, y2, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(skyLight, blockLight).func_181675_d();
            }
            if (y1 > 0.0 || tileEntity.getFluidAmountBelow() == 0) {
                buffer.func_181662_b(0.125, y1, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v1).func_187314_a(skyLight, blockLight).func_181675_d();
                buffer.func_181662_b(0.875, y1, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v1).func_187314_a(skyLight, blockLight).func_181675_d();
                buffer.func_181662_b(0.875, y1, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v2).func_187314_a(skyLight, blockLight).func_181675_d();
                buffer.func_181662_b(0.125, y1, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v2).func_187314_a(skyLight, blockLight).func_181675_d();
            }
            buffer.func_181662_b(0.875, y2, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v4).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.875, y1, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v3).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.125, y1, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v3).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.125, y2, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v4).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.875, y2, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u4, v4).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.875, y1, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u4, v3).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.875, y1, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u3, v3).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.875, y2, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u3, v4).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.125, y2, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v4).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.125, y1, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u1, v3).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.875, y1, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v3).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.875, y2, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u2, v4).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.125, y2, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u3, v4).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.125, y1, 0.125).func_181666_a(red, green, blue, alpha).func_187315_a(u3, v3).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.125, y1, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u4, v3).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b(0.125, y2, 0.875).func_181666_a(red, green, blue, alpha).func_187315_a(u4, v4).func_187314_a(skyLight, blockLight).func_181675_d();
            tesselator.func_78381_a();
            buffer.func_178969_c(0.0, 0.0, 0.0);
            RenderHelper.func_74519_b();
            GlStateManager.popMatrix();
        }
    }
}

