/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.common.block.BlockContainerBetterStorage;
import io.github.tehstoneman.betterstorage.common.item.cardboard.ItemBlockCardboardBox;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityCardboardBox;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockCardboardBox
extends BlockContainerBetterStorage
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE_BOX = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public BlockCardboardBox() {
        super(Block.Properties.func_200945_a((Material)Material.field_151580_n).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityCardboardBox();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BOX;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityCardboardBox) {
            TileEntityCardboardBox cardboardBox = (TileEntityCardboardBox)tileentity;
            if (stack.func_82837_s()) {
                cardboardBox.setCustomName(stack.func_200301_q());
            }
            if (stack.func_77942_o()) {
                int uses;
                CompoundNBT nbt = stack.func_77978_p();
                if (nbt.func_74764_b("Color")) {
                    cardboardBox.setColor(nbt.func_74762_e("Color"));
                }
                if (nbt.func_74764_b("Inventory")) {
                    cardboardBox.inventory.deserializeNBT(nbt.func_74775_l("Inventory"));
                }
                int n = uses = nbt.func_74764_b("Uses") ? nbt.func_74762_e("Uses") : ItemBlockCardboardBox.getMaxUses();
                if (!(placer instanceof PlayerEntity && ((PlayerEntity)placer).func_184812_l_() || cardboardBox.isEmpty())) {
                    --uses;
                }
                cardboardBox.setUses(uses);
            }
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity;
        if (state.func_177230_c() != newState.func_177230_c() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityCardboardBox) {
            TileEntityCardboardBox cardboardBox = (TileEntityCardboardBox)tileentity;
            if (cardboardBox.uses < 1) {
                cardboardBox.dropInventoryItems();
            }
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return true;
        }
        INamedContainerProvider box = this.func_220052_b(state, worldIn, pos);
        if (box != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)box, (BlockPos)pos);
        }
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity;
        if (!worldIn.func_201670_d() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityCardboardBox) {
            TileEntityCardboardBox cardboardBox = (TileEntityCardboardBox)tileentity;
            if (player.func_184812_l_() && !cardboardBox.isEmpty() && cardboardBox.uses > 0) {
                ItemStack itemstack = this.func_185473_a((IBlockReader)worldIn, pos, state);
                CompoundNBT nbt = cardboardBox.func_189515_b(new CompoundNBT());
                if (nbt.func_74764_b("Inventory")) {
                    itemstack.func_77983_a("Inventory", nbt.func_74781_a("Inventory"));
                }
                if (cardboardBox.func_145818_k_()) {
                    itemstack.func_200302_a(cardboardBox.func_200201_e());
                }
                if (nbt.func_74764_b("Color")) {
                    itemstack.func_77983_a("Color", nbt.func_74781_a("Color"));
                }
                if (nbt.func_74764_b("Uses")) {
                    itemstack.func_77983_a("Uses", nbt.func_74781_a("Uses"));
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof TileEntityCardboardBox) {
            TileEntityCardboardBox cardboardBox = (TileEntityCardboardBox)tileentity;
            if (cardboardBox.uses == 0) {
                return Collections.emptyList();
            }
        }
        return super.func_220076_a(state, builder);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityCardboardBox) {
            return (TileEntityCardboardBox)tileentity;
        }
        return null;
    }

    public PushReaction func_149656_h(BlockState state) {
        return (Boolean)BetterStorageConfig.COMMON.cardboardBoxPistonBreakable.get() != false ? PushReaction.DESTROY : PushReaction.BLOCK;
    }
}

