/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import com.google.common.collect.Maps;
import io.github.tehstoneman.betterstorage.api.ConnectedType;
import io.github.tehstoneman.betterstorage.common.block.BlockConnectableContainer;
import io.github.tehstoneman.betterstorage.common.inventory.CrateStackHandler;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityCrate;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockCrate
extends BlockConnectableContainer {
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), facing -> {
        facing.put(Direction.NORTH, NORTH);
        facing.put(Direction.EAST, EAST);
        facing.put(Direction.SOUTH, SOUTH);
        facing.put(Direction.WEST, WEST);
        facing.put(Direction.UP, UP);
        facing.put(Direction.DOWN, DOWN);
    });

    public BlockCrate() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_196662_n));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityCrate();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntityCrate crate;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K && (crate = TileEntityCrate.getCrateAt((IBlockReader)worldIn, pos)) != null && !crate.hasID()) {
            CrateStackHandler handler = crate.getCrateStackHandler();
            handler.addCrate(crate);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        TileEntityCrate tileCrate;
        if (!world.func_201670_d() && (tileCrate = TileEntityCrate.getCrateAt((IBlockReader)world, pos)) != null) {
            TileEntityCrate facingCrate = TileEntityCrate.getCrateAt((IBlockReader)world, facingPos);
            state = (BlockState)((BlockState)state.func_206870_a((IProperty)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(tileCrate.tryAddCrate(facingCrate)))).func_206870_a((IProperty)TYPE, (Comparable)((Object)(tileCrate.getNumCrates() > 1 ? ConnectedType.PILE : ConnectedType.SINGLE)));
        }
        return super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return true;
        }
        INamedContainerProvider tileEntityCrate = this.func_220052_b(state, worldIn, pos);
        if (tileEntityCrate != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntityCrate, (BlockPos)pos);
        }
        return true;
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCrate) {
            return (TileEntityCrate)tileEntity;
        }
        return null;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityCrate tileCrate;
        if (!world.field_72995_K && state.func_177230_c() != newState.func_177230_c() && (tileCrate = TileEntityCrate.getCrateAt((IBlockReader)world, pos)) != null) {
            CrateStackHandler handler = tileCrate.getCrateStackHandler();
            NonNullList<ItemStack> overflow = tileCrate.removeCrate();
            if (!overflow.isEmpty()) {
                InventoryHelper.func_219961_a((World)world, (BlockPos)pos, overflow);
            }
            tileCrate.notifyRegionUpdate(handler.getRegion(), tileCrate.getPileID());
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }
}

