/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.api.ConnectedType;
import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.LockInteraction;
import io.github.tehstoneman.betterstorage.common.block.BlockConnectableContainer;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityContainer;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedChest;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockReinforcedChest
extends BlockConnectableContainer
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_SINGLE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public BlockReinforcedChest() {
        this(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185848_a));
    }

    public BlockReinforcedChest(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING, WATERLOGGED});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityReinforcedChest();
    }

    public boolean func_190946_v(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b((IProperty)TYPE) == ConnectedType.SINGLE) {
            return SHAPE_SINGLE;
        }
        switch (BlockReinforcedChest.getDirectionToAttached(state)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: 
        }
        return SHAPE_EAST;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction2;
        ConnectedType connectedType = ConnectedType.SINGLE;
        Direction direction = context.func_195992_f().func_176734_d();
        IFluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean sneaking = context.func_195998_g();
        Direction direction1 = context.func_196000_l();
        if (direction1.func_176740_k().func_176722_c() && sneaking && (direction2 = this.getDirectionToAttach(context, direction1.func_176734_d())) != null && direction2.func_176740_k() != direction1.func_176740_k()) {
            direction = direction2;
            ConnectedType connectedType2 = connectedType = direction2.func_176735_f() == direction1.func_176734_d() ? ConnectedType.MASTER : ConnectedType.SLAVE;
        }
        if (connectedType == ConnectedType.SINGLE && !sneaking) {
            if (direction == this.getDirectionToAttach(context, direction.func_176746_e())) {
                connectedType = ConnectedType.SLAVE;
            } else if (direction == this.getDirectionToAttach(context, direction.func_176735_f())) {
                connectedType = ConnectedType.MASTER;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)direction)).func_206870_a((IProperty)TYPE, (Comparable)((Object)connectedType))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facingState.func_177230_c() == this && facing.func_176740_k().func_176722_c()) {
            ConnectedType lockerType = (ConnectedType)((Object)facingState.func_177229_b((IProperty)TYPE));
            if (stateIn.func_177229_b((IProperty)TYPE) == ConnectedType.SINGLE && lockerType != ConnectedType.SINGLE && stateIn.func_177229_b((IProperty)FACING) == facingState.func_177229_b((IProperty)FACING) && BlockReinforcedChest.getDirectionToAttached(facingState) == facing.func_176734_d()) {
                return (BlockState)stateIn.func_206870_a((IProperty)TYPE, (Comparable)((Object)lockerType.opposite()));
            }
        } else if (BlockReinforcedChest.getDirectionToAttached(stateIn) == facing) {
            return (BlockState)stateIn.func_206870_a((IProperty)TYPE, (Comparable)((Object)ConnectedType.SINGLE));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    private Direction getDirectionToAttach(BlockItemUseContext context, Direction facing) {
        BlockState blockState = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(facing));
        return blockState.func_177230_c() == this && blockState.func_177229_b((IProperty)TYPE) == ConnectedType.SINGLE ? (Direction)blockState.func_177229_b((IProperty)FACING) : null;
    }

    public static Direction getDirectionToAttached(BlockState state) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        return state.func_177229_b((IProperty)TYPE) == ConnectedType.SLAVE ? direction.func_176746_e() : direction.func_176735_f();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityReinforcedChest) {
            ((TileEntityReinforcedChest)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityContainer) {
                ((TileEntityContainer)tileentity).dropInventoryItems();
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return BlockReinforcedChest.calcRedstoneFromInventory((LazyOptional<IItemHandler>)((TileEntityReinforcedChest)worldIn.func_175625_s(pos)).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY));
    }

    public static int calcRedstoneFromInventory(@Nullable LazyOptional<IItemHandler> lazyOptional) {
        if (!lazyOptional.isPresent()) {
            return 0;
        }
        IItemHandler inventory = (IItemHandler)lazyOptional.orElseGet(null);
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inventory.getSlots(); ++j) {
            ItemStack itemstack = inventory.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)itemstack.func_77976_d();
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inventory.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileEntity tileEntity = blockAccess.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReinforcedChest) {
            TileEntityReinforcedChest chest = (TileEntityReinforcedChest)tileEntity;
            return chest.isPowered() ? MathHelper.func_76125_a((int)chest.getPlayersUsing(), (int)0, (int)15) : 0;
        }
        return 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return side == Direction.UP ? blockState.func_185911_a(blockAccess, pos, side) : 0;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        INamedContainerProvider chest;
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntityReinforcedChest tileChest = BlockReinforcedChest.getChestAt(worldIn, pos);
        if (tileChest != null && tileChest.isLocked()) {
            if (!tileChest.unlockWith(player.func_184586_b(hand))) {
                ItemStack lock = tileChest.getLock();
                ((ILock)lock.func_77973_b()).applyEffects(lock, tileChest, player, LockInteraction.OPEN);
                return false;
            }
            if (player.func_70093_af()) {
                worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), tileChest.getLock().func_77946_l()));
                tileChest.setLock(ItemStack.field_190927_a);
                return true;
            }
        }
        if ((chest = this.func_220052_b(state, worldIn, pos)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)chest, (BlockPos)pos);
            player.func_71029_a(this.getOpenStat());
        }
        return true;
    }

    @Nullable
    public static TileEntityReinforcedChest getChestAt(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReinforcedChest) {
            return (TileEntityReinforcedChest)tileEntity;
        }
        return null;
    }

    protected Stat<ResourceLocation> getOpenStat() {
        return Stats.field_199092_j.func_199076_b((Object)Stats.field_188063_ac);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return this.getContainer(state, worldIn, pos, false);
    }

    @Nullable
    public TileEntityReinforcedChest getContainer(BlockState state, World worldIn, BlockPos pos, boolean allowBlockedChest) {
        ConnectedType chesttype1;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityReinforcedChest)) {
            return null;
        }
        if (!allowBlockedChest && BlockReinforcedChest.isBlocked((IWorld)worldIn, pos)) {
            return null;
        }
        TileEntityReinforcedChest ilockablecontainer = (TileEntityReinforcedChest)tileentity;
        ConnectedType chesttype = (ConnectedType)((Object)state.func_177229_b((IProperty)TYPE));
        if (chesttype == ConnectedType.SINGLE) {
            return ilockablecontainer;
        }
        BlockPos blockpos = pos.func_177972_a(BlockReinforcedChest.getDirectionToAttached(state));
        BlockState iblockstate = worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() == this && (chesttype1 = (ConnectedType)((Object)iblockstate.func_177229_b((IProperty)TYPE))) != ConnectedType.SINGLE && chesttype != chesttype1 && iblockstate.func_177229_b((IProperty)FACING) == state.func_177229_b((IProperty)FACING) && !allowBlockedChest && BlockReinforcedChest.isBlocked((IWorld)worldIn, blockpos)) {
            return null;
        }
        return ilockablecontainer;
    }

    private static boolean isBlocked(IWorld world, BlockPos pos) {
        return BlockReinforcedChest.isBelowSolidBlock((IBlockReader)world, pos) || BlockReinforcedChest.isCatSittingOn(world, pos);
    }

    private static boolean isBelowSolidBlock(IBlockReader reader, BlockPos worldIn) {
        BlockPos blockpos = worldIn.func_177984_a();
        return reader.func_180495_p(blockpos).func_215686_e(reader, blockpos);
    }

    private static boolean isCatSittingOn(IWorld world, BlockPos pos) {
        List list = world.func_217357_a(CatEntity.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)));
        if (!list.isEmpty()) {
            for (CatEntity catentity : list) {
                if (!catentity.func_70906_o()) continue;
                return true;
            }
        }
        return false;
    }

    public IFluidState func_204507_t(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(blockState);
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntityReinforcedChest chest = BlockReinforcedChest.getChestAt((World)world, pos);
        if (chest != null && chest.isLocked()) {
            int resist = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentBetterStorage.PERSISTANCE, (ItemStack)chest.getLock()) + 1;
            return super.getExplosionResistance(state, world, pos, exploder, explosion) * (float)resist * 2.0f;
        }
        return super.getExplosionResistance(state, world, pos, exploder, explosion);
    }
}

