/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import io.github.tehstoneman.betterstorage.api.lock.ILock;
import io.github.tehstoneman.betterstorage.api.lock.LockInteraction;
import io.github.tehstoneman.betterstorage.common.block.BlockLocker;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityReinforcedLocker;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockReinforcedLocker
extends BlockLocker {
    public BlockReinforcedLocker() {
        this(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185848_a));
    }

    public BlockReinforcedLocker(Block.Properties properties) {
        super(properties);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityReinforcedLocker();
    }

    @Override
    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hit.func_216354_b() == state.func_177229_b((IProperty)FACING)) {
            if (!worldIn.field_72995_K) {
                TileEntityReinforcedLocker tileChest = BlockReinforcedLocker.getChestAt(worldIn, pos);
                if (tileChest != null && tileChest.isLocked()) {
                    if (!tileChest.unlockWith(player.func_184586_b(hand))) {
                        ItemStack lock = tileChest.getLock();
                        ((ILock)lock.func_77973_b()).applyEffects(lock, tileChest, player, LockInteraction.OPEN);
                        return false;
                    }
                    if (player.func_70093_af()) {
                        worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), tileChest.getLock().func_77946_l()));
                        tileChest.setLock(ItemStack.field_190927_a);
                        return true;
                    }
                }
                return super.func_220051_a(state, worldIn, pos, player, hand, hit);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static TileEntityReinforcedLocker getChestAt(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReinforcedLocker) {
            return (TileEntityReinforcedLocker)tileEntity;
        }
        return null;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileEntity tileEntity = blockAccess.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReinforcedLocker) {
            TileEntityReinforcedLocker chest = (TileEntityReinforcedLocker)tileEntity;
            return chest.isPowered() ? MathHelper.func_76125_a((int)chest.getPlayersUsing(), (int)0, (int)15) : 0;
        }
        return 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return side == Direction.UP ? blockState.func_185911_a(blockAccess, pos, side) : 0;
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntityReinforcedLocker chest = BlockReinforcedLocker.getChestAt((World)world, pos);
        if (chest != null && chest.isLocked()) {
            int resist = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentBetterStorage.PERSISTANCE, (ItemStack)chest.getLock()) + 1;
            return super.getExplosionResistance(state, world, pos, exploder, explosion) * (float)resist * 2.0f;
        }
        return super.getExplosionResistance(state, world, pos, exploder, explosion);
    }
}

