/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.block;

import com.google.common.collect.Maps;
import io.github.tehstoneman.betterstorage.common.block.BlockContainerBetterStorage;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityTank;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BlockTank
extends BlockContainerBetterStorage {
    protected static final VoxelShape SHAPE_TANK = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), facing -> {
        facing.put(Direction.UP, UP);
        facing.put(Direction.DOWN, DOWN);
    });

    protected BlockTank() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150359_w).func_200943_b(3.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{UP, DOWN});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176740_k().func_176716_d() == Direction.Plane.VERTICAL ? (BlockState)stateIn.func_206870_a((IProperty)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(facingState.func_177230_c() == this)) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_TANK;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityTank();
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemStack = player.func_184586_b(hand);
        LazyOptional capability = itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (capability.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)capability.orElse(null);
            boolean success = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)world, (BlockPos)pos, (Direction)hit.func_216354_b());
            return success;
        }
        return super.func_220051_a(state, world, pos, player, hand, hit);
    }
}

