/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.capabilities;

import io.github.tehstoneman.betterstorage.api.ICrateStorage;
import io.github.tehstoneman.betterstorage.common.world.storage.CrateStorage;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CapabilityCrate {
    @CapabilityInject(value=ICrateStorage.class)
    public static final Capability<ICrateStorage> CRATE_PILE_CAPABILITY = null;
    public static ResourceLocation CAPABILITY_RESOURCE = new ResourceLocation("betterstorage", "crate_pile");

    public static void register() {
        CapabilityManager.INSTANCE.register(ICrateStorage.class, (Capability.IStorage)new Capability.IStorage<ICrateStorage>(){

            public INBT writeNBT(Capability<ICrateStorage> capability, ICrateStorage instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<ICrateStorage> capability, ICrateStorage instance, Direction side, INBT nbt) {
                if (!(instance instanceof CrateStorage)) {
                    throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
                }
                instance.deserializeNBT((INBT)((CompoundNBT)nbt));
            }
        }, CrateStorage::new);
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        private final Capability<ICrateStorage> capability;
        private final LazyOptional capabilityHandler;

        public Provider(Capability<ICrateStorage> capability) {
            this.capability = capability;
            this.capabilityHandler = LazyOptional.of(() -> this.capability);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
            return CRATE_PILE_CAPABILITY.orEmpty(capability, this.capabilityHandler);
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.capability.writeNBT(this.capability.getDefaultInstance(), null);
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.capability.readNBT(this.capability.getDefaultInstance(), null, (INBT)nbt);
        }
    }

    @Mod.EventBusSubscriber(modid="betterstorage", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void attachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
            event.addCapability(CAPABILITY_RESOURCE, (ICapabilityProvider)new Provider(CRATE_PILE_CAPABILITY));
        }
    }
}

