/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.enchantment;

import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentKey;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentLock;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="betterstorage")
public class EnchantmentBetterStorage {
    @ObjectHolder(value="unlocking")
    public static EnchantmentKey UNLOCKING;
    @ObjectHolder(value="lockpicking")
    public static EnchantmentKey LOCKPICKING;
    @ObjectHolder(value="morphing")
    public static EnchantmentKey MORPHING;
    @ObjectHolder(value="persistance")
    public static EnchantmentLock PERSISTANCE;
    @ObjectHolder(value="security")
    public static EnchantmentLock SECURITY;
    @ObjectHolder(value="shock")
    public static EnchantmentLock SHOCK;
    @ObjectHolder(value="trigger")
    public static EnchantmentLock TRIGGER;

    public static int getLevel(ItemStack stack, Enchantment enchantment) {
        if (stack.func_77948_v()) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            return enchantments.getOrDefault(enchantment, 0);
        }
        return 0;
    }

    public static void decEnchantment(ItemStack stack, Enchantment ench, int level) {
        if (stack.func_190926_b()) {
            return;
        }
        Map list = EnchantmentHelper.func_82781_a((ItemStack)stack);
        int newLevel = list.getOrDefault(ench, 0) - level;
        if (newLevel <= 0) {
            list.remove(ench);
        } else {
            list.put(ench, newLevel);
        }
        EnchantmentHelper.func_82782_a((Map)list, (ItemStack)stack);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class Register {
        private Register() {
        }

        @SubscribeEvent
        public static void onEnchantmentRegistry(RegistryEvent.Register<Enchantment> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register(new EnchantmentKey(Enchantment.Rarity.COMMON, 5, 5, 10, 30, 0).setRegistryName("unlocking"));
            registry.register(new EnchantmentKey(Enchantment.Rarity.COMMON, 5, 5, 8, 30, 0).setRegistryName("lockpicking"));
            registry.register(new EnchantmentKey(Enchantment.Rarity.COMMON, 5, 10, 12, 30, 0).setRegistryName("morphing"));
            registry.register(new EnchantmentLock(Enchantment.Rarity.COMMON, 5, 1, 8, 30, 0).setRegistryName("persistance"));
            registry.register(new EnchantmentLock(Enchantment.Rarity.COMMON, 5, 1, 8, 30, 0).setRegistryName("security"));
            registry.register(new EnchantmentLock(Enchantment.Rarity.COMMON, 5, 1, 8, 30, 0).setRegistryName("shock"));
            registry.register(new EnchantmentLock(Enchantment.Rarity.COMMON, 1, 1, 8, 30, 0).setRegistryName("trigger"));
        }
    }
}

