/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.enchantment;

import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import io.github.tehstoneman.betterstorage.common.item.locking.ItemKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public class EnchantmentKey
extends Enchantment {
    public static final EnchantmentType KEY = EnchantmentType.create((String)"key", item -> item instanceof ItemKey);
    private final int maxLevel;
    private final int minBase;
    private final int minScaling;
    private final int maxBase;
    private final int maxScaling;
    private List<Enchantment> incompatible = new ArrayList<Enchantment>(0);

    public EnchantmentKey(Enchantment.Rarity rarityIn, int maxLevel, int minBase, int minScaling, int maxBase, int maxScaling) {
        super(rarityIn, KEY, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND});
        this.maxLevel = maxLevel;
        this.minBase = minBase;
        this.minScaling = minScaling;
        this.maxBase = maxBase;
        this.maxScaling = maxScaling;
    }

    public void setIncompatible(Enchantment ... incompatible) {
        this.incompatible = Arrays.asList(incompatible);
    }

    public int func_77325_b() {
        return this.maxLevel;
    }

    public int func_77321_a(int level) {
        return this.minBase + (level - 1) * this.minScaling;
    }

    public int func_223551_b(int level) {
        return this.func_77321_a(level) + this.maxBase + (level - 1) * this.maxScaling;
    }

    public boolean func_77326_a(Enchantment other) {
        return super.func_77326_a(other) && !this.incompatible.contains(other);
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof IKey ? true : super.func_92089_a(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (stack.func_77973_b() instanceof IKey) {
            IKey key = (IKey)stack.func_77973_b();
            return key.canApplyEnchantment(stack, this);
        }
        return stack.func_77973_b() != BetterStorageItems.MASTER_KEY && stack.func_77973_b() instanceof IKey;
    }

    public boolean func_185261_e() {
        return super.func_185261_e();
    }
}

