/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.common.block.BetterStorageBlocks;
import io.github.tehstoneman.betterstorage.common.inventory.ContainerCardboardBox;
import io.github.tehstoneman.betterstorage.common.inventory.ContainerCrate;
import io.github.tehstoneman.betterstorage.common.inventory.ContainerKeyring;
import io.github.tehstoneman.betterstorage.common.inventory.ContainerLocker;
import io.github.tehstoneman.betterstorage.common.inventory.ContainerReinforcedChest;
import io.github.tehstoneman.betterstorage.common.inventory.ContainerReinforcedLocker;
import io.github.tehstoneman.betterstorage.common.item.BetterStorageItems;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="betterstorage")
public final class BetterStorageContainerTypes {
    @ObjectHolder(value="crate")
    public static ContainerType<ContainerCrate> CRATE;
    @ObjectHolder(value="reinforced_chest")
    public static ContainerType<ContainerReinforcedChest> REINFORCED_CHEST;
    @ObjectHolder(value="locker")
    public static ContainerType<ContainerLocker> LOCKER;
    @ObjectHolder(value="reinforced_locker")
    public static ContainerType<ContainerReinforcedLocker> REINFORCED_LOCKER;
    @ObjectHolder(value="keyring")
    public static ContainerType<ContainerKeyring> KEYRING;
    @ObjectHolder(value="cardboard_box")
    public static ContainerType<ContainerCardboardBox> CARDBOARD_BOX;

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class Register {
        private Register() {
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register(IForgeContainerType.create((windowID, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new ContainerCrate(windowID, inv, BetterStorage.PROXY.getClientWorld(), pos);
            }).setRegistryName(BetterStorageBlocks.CRATE.getRegistryName()));
            registry.register(IForgeContainerType.create((windowID, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new ContainerLocker(windowID, inv, BetterStorage.PROXY.getClientWorld(), pos);
            }).setRegistryName(BetterStorageBlocks.LOCKER.getRegistryName()));
            registry.register(IForgeContainerType.create((windowID, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new ContainerReinforcedChest(windowID, inv, BetterStorage.PROXY.getClientWorld(), pos);
            }).setRegistryName(BetterStorageBlocks.REINFORCED_CHEST.getRegistryName()));
            registry.register(IForgeContainerType.create((windowID, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new ContainerReinforcedLocker(windowID, inv, BetterStorage.PROXY.getClientWorld(), pos);
            }).setRegistryName(BetterStorageBlocks.REINFORCED_LOCKER.getRegistryName()));
            registry.register(IForgeContainerType.create((windowID, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new ContainerCardboardBox(windowID, inv, BetterStorage.PROXY.getClientWorld(), pos);
            }).setRegistryName(BetterStorageBlocks.CARDBOARD_BOX.getRegistryName()));
            registry.register(IForgeContainerType.create((windowID, inv, data) -> {
                ItemStack keyring = data.func_150791_c();
                int protectedIndex = data.readInt();
                return new ContainerKeyring(windowID, inv, keyring, protectedIndex);
            }).setRegistryName(BetterStorageItems.KEYRING.getRegistryName()));
        }
    }
}

