/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.inventory;

import io.github.tehstoneman.betterstorage.common.inventory.FluidTankHandler;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class StackedTankHandler
implements IFluidHandler {
    private final ArrayList<FluidTankHandler> tanks;
    private FluidStack baseFluid;

    public StackedTankHandler(ArrayList<FluidTankHandler> tankList) {
        this.tanks = tankList;
        this.baseFluid = this.getFluidInTank(0);
        if (this.baseFluid.isEmpty()) {
            this.baseFluid = this.getFluidInTank(this.tanks.size() - 1);
        }
    }

    public int getTanks() {
        return this.tanks.size();
    }

    public FluidStack getFluidInTank(int tank) {
        return tank < this.getTanks() ? this.tanks.get(tank).getFluidInTank(0) : FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return tank < this.getTanks() ? this.tanks.get(tank).getTankCapacity(0) : 0;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tanks.get(0).isFluidValid(0, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(0, resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.baseFluid.isEmpty()) {
                return Math.min(this.getTotalCapacity(), resource.getAmount());
            }
            if (!this.baseFluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.getTotalCapacity() - this.getTotalAmount(), resource.getAmount());
        }
        if (!this.baseFluid.isEmpty() && !this.baseFluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = 0;
        FluidStack filler = resource.copy();
        if (resource.getFluid().getAttributes().isLighterThanAir()) {
            for (int i = this.tanks.size() - 1; i >= 0; --i) {
                if (filler.isEmpty()) continue;
                int result = this.tanks.get(i).fill(filler, action);
                filler.shrink(result);
                filled += result;
            }
        } else {
            for (FluidTankHandler tank : this.tanks) {
                if (filler.isEmpty()) continue;
                int result = tank.fill(filler, action);
                filler.shrink(result);
                filled += result;
            }
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.baseFluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (action.simulate()) {
            return new FluidStack(this.baseFluid, Math.min(this.getTotalAmount(), maxDrain));
        }
        FluidStack returnFluid = FluidStack.EMPTY;
        if (this.baseFluid.getFluid().getAttributes().isLighterThanAir()) {
            for (FluidTankHandler tank : this.tanks) {
                if (maxDrain <= 0) continue;
                FluidStack fluid = tank.drain(maxDrain, action);
                if (returnFluid.isEmpty()) {
                    returnFluid = fluid;
                } else {
                    returnFluid.grow(fluid.getAmount());
                }
                maxDrain -= fluid.getAmount();
            }
        } else {
            for (int i = this.tanks.size() - 1; i >= 0; --i) {
                if (maxDrain <= 0) continue;
                FluidStack fluid = this.tanks.get(i).drain(maxDrain, action);
                if (returnFluid.isEmpty()) {
                    returnFluid = fluid;
                } else {
                    returnFluid.grow(fluid.getAmount());
                }
                maxDrain -= fluid.getAmount();
            }
        }
        return returnFluid;
    }

    public int getTotalCapacity() {
        int capacity = 0;
        for (FluidTankHandler tank : this.tanks) {
            capacity += tank.getTankCapacity(0);
        }
        return capacity;
    }

    public int getTotalAmount() {
        int amount = 0;
        for (FluidTankHandler tank : this.tanks) {
            amount += tank.getFluidAmount();
        }
        return amount;
    }
}

