/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import com.google.common.collect.Iterables;
import io.github.tehstoneman.betterstorage.BetterStorage;
import io.github.tehstoneman.betterstorage.common.inventory.ContainerCrate;
import io.github.tehstoneman.betterstorage.common.inventory.CrateStackHandler;
import io.github.tehstoneman.betterstorage.common.inventory.Region;
import io.github.tehstoneman.betterstorage.common.tileentity.BetterStorageTileEntityTypes;
import io.github.tehstoneman.betterstorage.common.tileentity.TileEntityContainer;
import io.github.tehstoneman.betterstorage.common.world.CrateStackCollection;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import io.github.tehstoneman.betterstorage.network.UpdateCrateMessage;
import io.github.tehstoneman.betterstorage.utils.BlockUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import org.antlr.v4.runtime.misc.NotNull;

public class TileEntityCrate
extends TileEntityContainer {
    private static final int maxCratePileSize = 125;
    public static final int slotsPerCrate = 18;
    public static final int MAX_CRATES = 125;
    public static final int MAX_PER_SIDE = 5;
    private UUID pileID;
    protected ITextComponent customName;
    private int numCrates = 1;
    private int capacity = 18;
    private String customTitle;

    public TileEntityCrate(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TileEntityCrate() {
        this(BetterStorageTileEntityTypes.CRATE);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null && !((Boolean)BetterStorageConfig.COMMON.crateAllowAutomation.get()).booleanValue()) {
                return LazyOptional.empty();
            }
            LazyOptional crateHandler = LazyOptional.of(() -> this.getCrateStackHandler());
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, crateHandler);
        }
        return super.getCapability(capability, facing);
    }

    public boolean hasID() {
        return this.pileID != null;
    }

    public CrateStackHandler getCrateStackHandler() {
        if (this.field_145850_b.field_72995_K) {
            return new CrateStackHandler(this.getCapacity());
        }
        CrateStackCollection collection = CrateStackCollection.getCollection(this.field_145850_b);
        CrateStackHandler handler = collection.getOrCreateCratePile(this.getPileID());
        handler.sendUpdatesTo(this);
        return handler;
    }

    public UUID getPileID() {
        if (this.pileID == null) {
            CrateStackCollection collection = CrateStackCollection.getCollection(this.field_145850_b);
            CrateStackHandler handler = collection.createCratePile();
            this.setPileID(handler.getPileID());
        }
        return this.pileID;
    }

    public void setPileID(@NotNull UUID pileID) {
        this.pileID = pileID;
        this.func_70296_d();
    }

    public void updateConnections() {
        if (!this.func_145831_w().field_72995_K) {
            CrateStackHandler handler = this.getCrateStackHandler();
            this.pileID = handler.getPileID();
            this.numCrates = handler.getNumCrates();
            this.checkPileConnections(this.pileID);
            this.func_70296_d();
            this.notifyRegionUpdate(handler.getRegion(), this.pileID);
        }
    }

    private void checkPileConnections(UUID pileID) {
        CrateStackHandler handler = this.getCrateStackHandler();
        CrateStackCollection collection = CrateStackCollection.getCollection(this.field_145850_b);
        if (handler.getNumCrates() <= 0) {
            collection.removeCratePile(pileID);
            BlockState state = this.func_195044_w();
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
            return;
        }
        List<HashSet<TileEntityCrate>> crateSets = this.getCrateSets(this.field_174879_c, pileID);
        if (crateSets.size() > 1) {
            for (HashSet set : Iterables.skip(crateSets, (int)1)) {
                CrateStackHandler newHandler = collection.createCratePile();
                for (TileEntityCrate crate : set) {
                    NonNullList<ItemStack> overflow = handler.removeCrate(crate);
                    newHandler.addCrate(crate);
                    if (overflow.isEmpty()) continue;
                    for (ItemStack stack : overflow) {
                        if (stack.func_190926_b()) continue;
                        newHandler.addItems(stack);
                    }
                }
                this.notifyRegionUpdate(newHandler.getRegion(), newHandler.getPileID());
            }
        }
        handler.trimRegion(this.func_145831_w());
        this.notifyRegionUpdate(handler.getRegion(), this.getPileID());
    }

    private List<HashSet<TileEntityCrate>> getCrateSets(BlockPos pos, UUID pileID) {
        ArrayList<HashSet<TileEntityCrate>> crateSets = new ArrayList<HashSet<TileEntityCrate>>();
        int checkedCrates = 0;
        for (Direction dir : Direction.values()) {
            TileEntityCrate tileCrate = TileEntityCrate.getCrateAt((IBlockReader)this.field_145850_b, pos.func_177972_a(dir));
            if (tileCrate == null || this.isInSet(tileCrate, crateSets)) continue;
            HashSet<TileEntityCrate> set = new HashSet<TileEntityCrate>();
            set.add(tileCrate);
            for (Direction ndir : Direction.values()) {
                this.checkConnections(tileCrate.func_174877_v().func_177972_a(ndir), pileID, set);
            }
            crateSets.add(set);
            checkedCrates += set.size();
        }
        return crateSets;
    }

    private boolean isInSet(TileEntityCrate tileCrate, List<HashSet<TileEntityCrate>> crateSets) {
        for (HashSet<TileEntityCrate> set : crateSets) {
            if (!set.contains((Object)tileCrate)) continue;
            return true;
        }
        return false;
    }

    private void checkConnections(BlockPos pos, UUID pileID, HashSet<TileEntityCrate> set) {
        TileEntityCrate tileCrate = TileEntityCrate.getCrateAt((IBlockReader)this.field_145850_b, pos);
        if (tileCrate == null || tileCrate == this || !pileID.equals(tileCrate.getPileID()) || set.contains((Object)tileCrate)) {
            return;
        }
        set.add(tileCrate);
        for (Direction ndir : Direction.values()) {
            this.checkConnections(pos.func_177972_a(ndir), pileID, set);
        }
    }

    public void notifyRegionUpdate(Region region, UUID pileID) {
        if (region == null || region.isEmpty()) {
            return;
        }
        for (BlockPos blockPos : BlockUtils.getAllInBox(region)) {
            TileEntity te = this.func_145831_w().func_175625_s(blockPos);
            if (!(te instanceof TileEntityCrate) || !((TileEntityCrate)te).pileID.equals(pileID)) continue;
            te.func_70296_d();
            BlockState state = this.func_145831_w().func_180495_p(blockPos);
            this.func_145831_w().func_184138_a(blockPos, state, state, 3);
        }
    }

    public void setCustomTitle(String displayName) {
        this.customTitle = displayName;
    }

    public int getNumCrates() {
        if (this.func_145831_w().field_72995_K) {
            return this.numCrates;
        }
        return this.getCrateStackHandler().getNumCrates();
    }

    public void setNumCrates(int numCrates) {
        this.numCrates = numCrates;
    }

    public int getCapacity() {
        if (this.func_145831_w().field_72995_K) {
            return this.capacity;
        }
        return this.getCrateStackHandler().getCapacity();
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            CrateStackCollection.getCollection(this.func_145831_w()).func_76185_a();
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.pileID != null) {
            nbt.func_186854_a("PileID", this.pileID);
        }
        nbt.func_74768_a("NumCrates", this.getNumCrates());
        nbt.func_74768_a("Capacity", this.getCapacity());
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager network, SUpdateTileEntityPacket packet) {
        CompoundNBT nbt = packet.func_148857_g();
        if (nbt.func_186855_b("PileID")) {
            this.pileID = nbt.func_186857_a("PileID");
        }
        this.numCrates = nbt.func_74762_e("NumCrates");
        this.capacity = nbt.func_74762_e("Capacity");
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.pileID != null) {
            nbt.func_186854_a("PileID", this.pileID);
        }
        nbt.func_74768_a("NumCrates", this.getNumCrates());
        nbt.func_74768_a("Capacity", this.getCapacity());
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundNBT nbt) {
        super.handleUpdateTag(nbt);
        if (nbt.func_186855_b("PileID")) {
            this.pileID = nbt.func_186857_a("PileID");
        }
        this.numCrates = nbt.func_74762_e("NumCrates");
        this.capacity = nbt.func_74762_e("Capacity");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.pileID != null) {
            nbt.func_186854_a("PileID", this.pileID);
        }
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_186855_b("PileID")) {
            this.pileID = nbt.func_186857_a("PileID");
        }
    }

    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity player) {
        BetterStorage.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new UpdateCrateMessage(this.field_174879_c, this.getNumCrates(), this.getCapacity()));
        return new ContainerCrate(windowID, playerInventory, this.field_145850_b, this.field_174879_c);
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent("container.betterstorage.crate", new Object[0]);
    }

    @Nullable
    public static TileEntityCrate getCrateAt(IBlockReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCrate) {
            return (TileEntityCrate)tileEntity;
        }
        return null;
    }

    public boolean tryAddCrate(@Nullable TileEntityCrate crate) {
        if (crate == null) {
            return false;
        }
        if (crate.getPileID().equals(this.pileID)) {
            return true;
        }
        CrateStackHandler handler = this.getCrateStackHandler();
        Region region = handler.getRegion().clone();
        if (crate.getNumCrates() > 1) {
            region.expandToContain(crate.getCrateStackHandler().getRegion());
        } else {
            region.expandToContain(crate);
        }
        if (region.width() > 5 || region.height() > 5 || region.depth() > 5) {
            return false;
        }
        for (BlockPos blockPos : BlockUtils.getAllInBox(region.posMin, region.posMax)) {
            TileEntityCrate newCrate = TileEntityCrate.getCrateAt((IBlockReader)this.field_145850_b, blockPos);
            if (newCrate == null || newCrate.getPileID().equals(this.pileID)) continue;
            handler.addCrate(newCrate);
        }
        this.notifyRegionUpdate(region, this.pileID);
        return true;
    }

    public NonNullList<ItemStack> removeCrate() {
        NonNullList<ItemStack> overflow = this.getCrateStackHandler().removeCrate(this);
        this.checkPileConnections(this.pileID);
        return overflow;
    }
}

