/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.api.lock.IKey;
import io.github.tehstoneman.betterstorage.api.lock.IKeyLockable;
import io.github.tehstoneman.betterstorage.common.enchantment.EnchantmentBetterStorage;
import io.github.tehstoneman.betterstorage.common.tileentity.BetterStorageTileEntityTypes;
import io.github.tehstoneman.betterstorage.utils.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityLockableDoor
extends TileEntity
implements IKeyLockable {
    private ItemStack lock = ItemStack.field_190927_a.func_77946_l();
    private final boolean powered = false;

    public TileEntityLockableDoor() {
        super(BetterStorageTileEntityTypes.LOCKABLE_DOOR);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return WorldUtils.getAABB(this, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public boolean isMain() {
        return this.func_195044_w().func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER;
    }

    public TileEntity getMain() {
        if (this.isMain()) {
            return this;
        }
        return this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
    }

    public boolean isPowered() {
        if (this.isMain()) {
            return EnchantmentHelper.func_77506_a((Enchantment)EnchantmentBetterStorage.TRIGGER, (ItemStack)this.getLock()) > 0;
        }
        return ((TileEntityLockableDoor)this.getMain()).isPowered();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (!this.lock.func_190926_b()) {
            nbt.func_218657_a("lock", (INBT)this.lock.serializeNBT());
        }
        return nbt;
    }

    public void onDataPacket(NetworkManager network, SUpdateTileEntityPacket packet) {
        CompoundNBT nbt = packet.func_148857_g();
        if (nbt.func_74764_b("lock")) {
            CompoundNBT lockNBT = (CompoundNBT)nbt.func_74781_a("lock");
            this.lock = ItemStack.func_199557_a((CompoundNBT)lockNBT);
        } else {
            this.lock = ItemStack.field_190927_a;
        }
    }

    public void handleUpdateTag(CompoundNBT nbt) {
        super.handleUpdateTag(nbt);
        if (nbt.func_74764_b("lock")) {
            CompoundNBT lockNBT = (CompoundNBT)nbt.func_74781_a("lock");
            this.lock = ItemStack.func_199557_a((CompoundNBT)lockNBT);
        } else {
            this.lock = ItemStack.field_190927_a;
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        if (!this.lock.func_190926_b()) {
            CompoundNBT lockNBT = new CompoundNBT();
            this.lock.func_77955_b(lockNBT);
            nbt.func_218657_a("lock", (INBT)lockNBT);
        }
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("lock")) {
            CompoundNBT lockNBT = (CompoundNBT)nbt.func_74781_a("lock");
            this.lock = ItemStack.func_199557_a((CompoundNBT)lockNBT);
        } else {
            this.lock = ItemStack.field_190927_a;
        }
        super.func_145839_a(nbt);
    }

    @Override
    public ItemStack getLock() {
        if (this.isMain()) {
            return this.lock;
        }
        return ((TileEntityLockableDoor)this.getMain()).getLock();
    }

    @Override
    public void setLock(ItemStack lock) {
        if (lock.func_190926_b()) {
            this.lock = ItemStack.field_190927_a;
            BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150454_av.func_176223_P().func_206870_a((IProperty)DoorBlock.field_176520_a, blockState.func_177229_b((IProperty)DoorBlock.field_176520_a))).func_206870_a((IProperty)DoorBlock.field_176519_b, blockState.func_177229_b((IProperty)DoorBlock.field_176519_b))).func_206870_a((IProperty)DoorBlock.field_176521_M, blockState.func_177229_b((IProperty)DoorBlock.field_176521_M))).func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), (BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_150454_av.func_176223_P().func_206870_a((IProperty)DoorBlock.field_176520_a, blockState.func_177229_b((IProperty)DoorBlock.field_176520_a))).func_206870_a((IProperty)DoorBlock.field_176519_b, blockState.func_177229_b((IProperty)DoorBlock.field_176519_b))).func_206870_a((IProperty)DoorBlock.field_176521_M, blockState.func_177229_b((IProperty)DoorBlock.field_176521_M))).func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER));
            this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
        } else if (this.isLockValid(lock)) {
            this.setLockWithUpdate(lock);
        }
    }

    public void setLockWithUpdate(ItemStack lock) {
        this.lock = lock;
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 3);
        this.func_70296_d();
    }

    @Override
    public boolean canUse(PlayerEntity player) {
        return false;
    }

    @Override
    public void applyTrigger() {
    }

    @Override
    public boolean unlockWith(ItemStack heldItem) {
        Item item = heldItem.func_77973_b();
        return item instanceof IKey ? ((IKey)item).unlock(heldItem, this.getLock(), false) : false;
    }
}

