/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.betterstorage.common.tileentity;

import io.github.tehstoneman.betterstorage.common.block.BlockTank;
import io.github.tehstoneman.betterstorage.common.inventory.FluidTankHandler;
import io.github.tehstoneman.betterstorage.common.inventory.StackedTankHandler;
import io.github.tehstoneman.betterstorage.common.tileentity.BetterStorageTileEntityTypes;
import io.github.tehstoneman.betterstorage.config.BetterStorageConfig;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityTank
extends TileEntity {
    private final FluidTankHandler fluidTank;
    private final LazyOptional<IFluidHandler> fluidHandler;
    private StackedTankHandler stackedTank;
    private final LazyOptional<IFluidHandler> stackedHandler;
    private BlockPos mainPos;
    private int tankCount;

    public TileEntityTank() {
        super(BetterStorageTileEntityTypes.GLASS_TANK);
        this.fluidTank = new FluidTankHandler((Integer)BetterStorageConfig.COMMON.tankBuckets.get() * 1000){

            @Override
            protected void onContentsChanged() {
                TileEntityTank.this.func_70296_d();
            }
        };
        this.fluidHandler = LazyOptional.of(() -> this.fluidTank);
        this.stackedHandler = LazyOptional.of(() -> this.stackedTank);
        this.mainPos = BlockPos.field_177992_a;
        this.tankCount = 1;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.isMain()) {
                if (this.isStacked()) {
                    this.stackedTank = new StackedTankHandler(this.getStackedTanks());
                    return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(capability, this.stackedHandler);
                }
                return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(capability, this.fluidHandler);
            }
            return this.getMain().getCapability(capability, side);
        }
        return super.getCapability(capability, side);
    }

    public FluidStack getFluid() {
        return this.fluidTank.getFluidInTank(0);
    }

    public int getCapacity() {
        return this.fluidTank.getTankCapacity(0);
    }

    public TileEntityTank getTankAt(BlockPos pos) {
        return (TileEntityTank)this.field_145850_b.func_175625_s(pos);
    }

    public boolean isMain() {
        return (Boolean)this.func_195044_w().func_177229_b((IProperty)BlockTank.DOWN) == false;
    }

    public TileEntityTank getMain() {
        if (this.mainPos.equals((Object)BlockPos.field_177992_a)) {
            if (this.isMain()) {
                return this;
            }
            TileEntityTank mainTank = this.getTankAt(this.field_174879_c.func_177977_b()).getMain();
            this.mainPos = mainTank.func_174877_v();
            return mainTank;
        }
        return this.getTankAt(this.mainPos);
    }

    public int getFluidAmountAbove() {
        TileEntityTank tank = this.getTankAt(this.field_174879_c.func_177984_a());
        return tank != null ? tank.getFluid().getAmount() : 0;
    }

    public int getFluidAmountBelow() {
        TileEntityTank tank = this.getTankAt(this.field_174879_c.func_177977_b());
        return tank != null ? tank.getFluid().getAmount() : 0;
    }

    public boolean isStacked() {
        BlockState state = this.func_195044_w();
        return (Boolean)state.func_177229_b((IProperty)BlockTank.UP) != false || (Boolean)state.func_177229_b((IProperty)BlockTank.DOWN) != false;
    }

    public FluidTankHandler getHandler() {
        return this.fluidTank;
    }

    public ArrayList<FluidTankHandler> getStackedTanks() {
        ArrayList<FluidTankHandler> tanks = new ArrayList<FluidTankHandler>();
        BlockPos tankPos = this.field_174879_c;
        while (this.field_145850_b.func_180495_p(tankPos).func_177230_c() instanceof BlockTank) {
            tanks.add(this.getTankAt(tankPos).getHandler());
            tankPos = tankPos.func_177984_a();
        }
        return tanks;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.fluidTank.writeToNBT(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundNBT nbt) {
        super.handleUpdateTag(nbt);
        this.fluidTank.readFromNBT(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.fluidTank.writeToNBT(nbt);
        nbt.func_74768_a("tankCount", this.tankCount);
        if (!this.mainPos.equals((Object)BlockPos.field_177992_a)) {
            nbt.func_74772_a("mainPos", this.mainPos.func_218275_a());
        }
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(CompoundNBT nbt) {
        this.fluidTank.readFromNBT(nbt);
        this.tankCount = nbt.func_74762_e("tankCount");
        if (nbt.func_74764_b("mainPos")) {
            this.mainPos = BlockPos.func_218283_e((long)nbt.func_74763_f("mainPos"));
        }
        super.func_145839_a(nbt);
    }
}

